/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.content.blocks.AquaticCatalystBlock;
import com.portingdeadmods.nautec.content.blocks.CrateBlock;
import com.portingdeadmods.nautec.content.blocks.LaserJunctionBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.controller.AugmentationStationBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.part.DrainPartBlock;
import com.portingdeadmods.nautec.content.multiblocks.AugmentationStationMultiblock;
import com.portingdeadmods.nautec.content.multiblocks.DrainMultiblock;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTMultiblocks;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.IntegerRange;
import org.jetbrains.annotations.NotNull;

public class BlockModelProvider
extends BlockStateProvider {
    public BlockModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "nautec", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.axisBlock((RotatedPillarBlock)NTBlocks.DARK_PRISMARINE_PILLAR.get());
        this.simpleBlock((Block)NTBlocks.CHISELED_DARK_PRISMARINE.get());
        this.simpleBlock((Block)NTBlocks.PRISMARINE_SAND.get());
        this.simpleBlock((Block)NTBlocks.POLISHED_PRISMARINE.get());
        this.simpleBlock((Block)NTBlocks.AQUARINE_STEEL_BLOCK.get());
        this.simpleBlock((Block)NTBlocks.CREATIVE_POWER_SOURCE.get());
        this.aquaticCatalyst((AquaticCatalystBlock)NTBlocks.AQUATIC_CATALYST.get());
        this.existingFacingBlock((Block)NTBlocks.PRISMARINE_RELAY.get());
        this.longDistanceLaser((Block)NTBlocks.LONG_DISTANCE_LASER.get());
        this.laserJunction((Block)NTBlocks.LASER_JUNCTION.get());
        this.simpleBlock((Block)NTBlocks.MIXER.get(), (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.MIXER.get())));
        this.simpleBlock((Block)NTBlocks.CHARGER.get(), (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.CHARGER.get())));
        this.crateBlock((CrateBlock)((Object)NTBlocks.CRATE.get()));
        this.rustyCrateBlock((CrateBlock)((Object)NTBlocks.RUSTY_CRATE.get()));
        this.drainController((Block)NTBlocks.DRAIN.get());
        this.drainPart((Block)NTBlocks.DRAIN_PART.get(), IntegerRange.of((int)0, (int)8));
        this.augmentationStationController((AugmentationStationBlock)((Object)NTBlocks.AUGMENTATION_STATION.get()));
        this.augmentationStationPart((Block)NTBlocks.AUGMENTATION_STATION_PART.get(), IntegerRange.of((int)0, (int)8));
        this.augmentationStationExtension((Block)NTBlocks.AUGMENTATION_STATION_EXTENSION.get());
        this.simpleBlock((Block)NTBlocks.DRAIN_WALL.get());
    }

    private void augmentationStationController(AugmentationStationBlock augmentationStationBlock) {
        ModelFile.ExistingModelFile formedModel = this.models().getExistingFile(this.existingModelFile("multiblock/augmentation_station_4"));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)augmentationStationBlock).partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)formedModel).addModel()).partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.unformedAugmentationStationPart((Block)augmentationStationBlock, "controller")).addModel();
    }

    private void augmentationStationExtension(Block augmentationStationExtensionBlock) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(augmentationStationExtensionBlock);
        builder.partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.unformedAugmentationStationPart(augmentationStationExtensionBlock, "extension")).addModel();
        for (Direction dir : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
            builder.partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.existingModelFile("multiblock/augmentation_station_extension"))).rotationY(((int)dir.toYRot() + 180) % 360).addModel();
        }
    }

    private void augmentationStationPart(Block augmentationStationPartBlock, IntegerRange range) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(augmentationStationPartBlock);
        builder.partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.drainPartModel(augmentationStationPartBlock, 0, false)).addModel();
        for (int i = ((Integer)range.getMinimum()).intValue(); i <= (Integer)range.getMaximum(); ++i) {
            ModelFile.ExistingModelFile formedModel = this.models().getExistingFile(this.existingModelFile("multiblock/augmentation_station_" + (8 - i)));
            int index = i;
            if (i == 0 || i == 3 || i == 6) {
                index += 2;
            } else if (i == 2 || i == 5 || i == 8) {
                index -= 2;
            }
            builder.partialState().with((Property)Multiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)AugmentationStationMultiblock.AS_PART, (Comparable)Integer.valueOf(index)).modelForState().modelFile((ModelFile)formedModel).addModel();
        }
    }

    @NotNull
    private BlockModelBuilder unformedAugmentationStationPart(Block augmentationStationController, String part) {
        Multiblock multiblock = NTMultiblocks.AUGMENTATION_STATION.get();
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(this.name(augmentationStationController), "cube");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.multiblockTexture(multiblock, "unformed/" + part + "_top"))).texture("down", this.multiblockTexture(multiblock, "unformed/" + part + "_bottom"))).texture("north", this.multiblockTexture(multiblock, "unformed/" + part + "_side"))).texture("east", this.multiblockTexture(multiblock, "unformed/" + part + "_side"))).texture("south", this.multiblockTexture(multiblock, "unformed/" + part + "_side"))).texture("west", this.multiblockTexture(multiblock, "unformed/" + part + "_side"));
        return builder;
    }

    private void drainController(Block drainController) {
        Multiblock multiblock = NTMultiblocks.DRAIN.get();
        BlockModelBuilder unformedModel = this.drainControllerModel(drainController, multiblock, false);
        this.getVariantBuilder(drainController).partialState().with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)unformedModel).addModel();
        BlockModelBuilder formedModel = this.drainControllerModel(drainController, multiblock, true);
        this.getVariantBuilder(drainController).partialState().with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)formedModel).addModel();
    }

    @NotNull
    private BlockModelBuilder drainControllerModel(Block drainController, Multiblock multiblock, boolean formed) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(this.name(drainController) + (formed ? "_formed" : ""), "cube");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.multiblockTexture(multiblock, formed ? "top_4" : "drain_top_unformed"))).texture("down", this.multiblockTexture(multiblock, formed ? "bottom_4" : "drain_bottom_unformed"))).texture("north", this.multiblockTexture(multiblock, "drain_side_unformed"))).texture("east", this.multiblockTexture(multiblock, "drain_side_unformed"))).texture("south", this.multiblockTexture(multiblock, "drain_side_unformed"))).texture("west", this.multiblockTexture(multiblock, "drain_side_unformed"));
        return builder;
    }

    private void drainPart(Block drainPartBlock, IntegerRange range) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(drainPartBlock);
        builder.partialState().with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.drainPartModel(drainPartBlock, 0, false)).addModel();
        for (int i = ((Integer)range.getMinimum()).intValue(); i <= (Integer)range.getMaximum(); ++i) {
            builder.partialState().with((Property)DrainMultiblock.DRAIN_PART, (Comparable)Integer.valueOf(i)).with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)DrainPartBlock.LASER_PORT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.drainPartModel(drainPartBlock, i, false)).addModel();
            builder.partialState().with((Property)DrainMultiblock.DRAIN_PART, (Comparable)Integer.valueOf(i)).with((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(true)).with((Property)DrainPartBlock.LASER_PORT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.drainPartModel(drainPartBlock, i, true)).addModel();
        }
    }

    private ModelFile drainPartModel(Block drainPartBlock, int index, boolean laserPort) {
        String postfix = laserPort ? "_open" : "";
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(this.name(drainPartBlock) + "_" + index + postfix, "cube");
        Multiblock multiblock = NTMultiblocks.DRAIN.get();
        if (index % 2 != 0) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.multiblockTexture(multiblock, "top_" + index))).texture("down", this.multiblockTexture(multiblock, "bottom_" + index))).texture("north", this.multiblockTexture(multiblock, "side_1" + postfix))).texture("east", this.multiblockTexture(multiblock, "side_1" + postfix))).texture("south", this.multiblockTexture(multiblock, "side_1" + postfix))).texture("west", this.multiblockTexture(multiblock, "side_1" + postfix));
        } else if (index == 0 || index == 2) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.multiblockTexture(multiblock, "top_" + index))).texture("down", this.multiblockTexture(multiblock, "bottom_" + index))).texture("north", this.multiblockTexture(multiblock, "side_" + (2 - index % 3)))).texture("east", this.multiblockTexture(multiblock, "side_" + index % 3))).texture("south", this.multiblockTexture(multiblock, "side_" + (2 - index % 3)))).texture("west", this.multiblockTexture(multiblock, "side_" + index % 3));
        } else {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("up", this.multiblockTexture(multiblock, "top_" + index))).texture("down", this.multiblockTexture(multiblock, "bottom_" + index))).texture("north", this.multiblockTexture(multiblock, "side_" + index % 3))).texture("east", this.multiblockTexture(multiblock, "side_" + (2 - index % 3)))).texture("south", this.multiblockTexture(multiblock, "side_" + index % 3))).texture("west", this.multiblockTexture(multiblock, "side_" + (2 - index % 3)));
        }
        return builder;
    }

    private void laserJunction(Block block) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        this.laserJunctionConnection(builder, block, Direction.DOWN, 0, 0);
        this.laserJunctionConnection(builder, block, Direction.UP, 180, 0);
        this.laserJunctionConnection(builder, block, Direction.NORTH, 90, 180);
        this.laserJunctionConnection(builder, block, Direction.EAST, 90, 270);
        this.laserJunctionConnection(builder, block, Direction.SOUTH, 90, 0);
        this.laserJunctionConnection(builder, block, Direction.WEST, 90, 90);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.extend(this.existingModelFile(block), "_base"))).addModel()).end();
    }

    private void laserJunctionConnection(MultiPartBlockStateBuilder builder, Block block, Direction direction, int x, int y) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.extend(this.existingModelFile(block), "_connection_in"))).rotationX(x).rotationY(y).addModel()).condition(LaserJunctionBlock.CONNECTION[direction.ordinal()], (Comparable[])new LaserJunctionBlock.ConnectionType[]{LaserJunctionBlock.ConnectionType.INPUT}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.extend(this.existingModelFile(block), "_connection_out"))).rotationX(x).rotationY(y).addModel()).condition(LaserJunctionBlock.CONNECTION[direction.ordinal()], (Comparable[])new LaserJunctionBlock.ConnectionType[]{LaserJunctionBlock.ConnectionType.OUTPUT}).end();
    }

    public void longDistanceLaser(Block block) {
        BlockModelBuilder modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "cube")).texture("up", this.extend(this.blockTexture(block), "_top"))).texture("down", this.extend(this.blockTexture(block), "_bottom"))).texture("north", this.extend(this.blockTexture(block), "_side"))).texture("east", this.extend(this.blockTexture(block), "_side"))).texture("south", this.extend(this.blockTexture(block), "_side"))).texture("west", this.extend(this.blockTexture(block), "_side"));
        this.facingBlock(block, (ModelFile)modelBuilder);
    }

    public void existingFacingBlock(Block block) {
        this.facingBlock(block, (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.PRISMARINE_RELAY.get())));
    }

    public void facingBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().modelFile(model).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile(model).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile(model).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().modelFile(model).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().modelFile(model).rotationX(90).rotationY(270).addModel();
    }

    private void crateBlock(CrateBlock crateBlock) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)crateBlock);
        builder.partialState().with((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.existingModelFile((Block)crateBlock))).addModel();
        builder.partialState().with((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.extend(this.existingModelFile((Block)crateBlock), "_open"))).addModel();
    }

    private void rustyCrateBlock(CrateBlock crateBlock) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)crateBlock);
        builder.partialState().with((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.rustedCrateModel(crateBlock, true)).addModel();
        builder.partialState().with((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.rustedCrateModel(crateBlock, false)).addModel();
    }

    private ModelFile rustedCrateModel(CrateBlock block, boolean open) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block) + (open ? "_open" : ""), this.extend(this.existingModelFile((Block)NTBlocks.CRATE.get()), open ? "_open" : ""))).texture("2", "nautec:block/crate/rusty_top_inner")).texture("4", "nautec:block/crate/rusty")).texture("5", "nautec:block/crate/rusty_top")).texture("particle", "nautec:block/crate/rusty");
    }

    public ResourceLocation multiblockTexture(Multiblock multiblock, String name) {
        return this.modLoc("block/multiblock/" + NTRegistries.MULTIBLOCK.getKey((Object)multiblock).getPath() + "/" + name);
    }

    private void aquaticCatalyst(AquaticCatalystBlock block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        builder.partialState().with((Property)AquaticCatalystBlock.CORE_ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().cubeAll(this.name((Block)block), this.blockTexture((Block)block))).addModel();
        for (Direction direction : Direction.values()) {
            builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).with((Property)AquaticCatalystBlock.CORE_ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.createActiveACModel(block, direction)).addModel();
        }
    }

    private ModelFile createActiveACModel(AquaticCatalystBlock block, Direction activeSide) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(this.name((Block)block) + "_" + activeSide.getSerializedName(), "cube");
        for (Direction dir : Direction.values()) {
            if (dir == activeSide) {
                builder.texture(dir.getName(), this.extend(this.blockTexture((Block)block), "_active"));
                continue;
            }
            builder.texture(dir.getName(), this.blockTexture((Block)block));
        }
        return builder;
    }

    private ResourceLocation existingModelFile(Block block) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath()));
    }

    private ResourceLocation existingModelFile(String name) {
        return this.modLoc("block/" + name);
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath() + suffix));
    }
}

