/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.nautec.api.augments.AugmentType;
import com.portingdeadmods.nautec.content.recipes.inputs.AugmentationRecipeInput;
import com.portingdeadmods.nautec.content.recipes.utils.IngredientWithCount;
import com.portingdeadmods.nautec.content.recipes.utils.RecipeUtils;
import com.portingdeadmods.nautec.utils.codec.AugmentCodecs;
import com.portingdeadmods.nautec.utils.codec.CodecUtils;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AugmentationRecipe(Item augmentItem, String desc, List<IngredientWithCount> ingredients, AugmentType<?> resultAugment) implements Recipe<AugmentationRecipeInput>
{
    public static final String NAME = "augmentation";

    public boolean matches(@NotNull AugmentationRecipeInput recipeInput, @NotNull Level level) {
        return RecipeUtils.compareItems(recipeInput.ingredients(), this.ingredients);
    }

    @NotNull
    public ItemStack assemble(@NotNull AugmentationRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return RecipeUtils.listToNonNullList(RecipeUtils.iWCToIngredientsSaveCount(this.ingredients));
    }

    public static class Serializer
    implements RecipeSerializer<AugmentationRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<AugmentationRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtils.ITEM_CODEC.fieldOf("augmentItem").forGetter(AugmentationRecipe::augmentItem), (App)Codec.STRING.fieldOf("desc").orElse((Object)"").forGetter(AugmentationRecipe::desc), (App)IngredientWithCount.CODEC.listOf().fieldOf("ingredients").forGetter(AugmentationRecipe::ingredients), (App)AugmentCodecs.AUGMENT_TYPE_CODEC.fieldOf("resultAugment").forGetter(AugmentationRecipe::resultAugment)).apply((Applicative)builder, AugmentationRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, AugmentationRecipe> STREAM_CODEC = StreamCodec.composite(CodecUtils.ITEM_STREAM_CODEC, AugmentationRecipe::augmentItem, (StreamCodec)ByteBufCodecs.STRING_UTF8, AugmentationRecipe::desc, (StreamCodec)IngredientWithCount.STREAM_CODEC.apply(ByteBufCodecs.list()), AugmentationRecipe::ingredients, AugmentCodecs.AUGMENT_TYPE_STREAM_CODEC, AugmentationRecipe::resultAugment, AugmentationRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<AugmentationRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, AugmentationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<AugmentationRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return AugmentationRecipe.NAME;
        }
    }
}

