/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.multiblocks;

import com.portingdeadmods.nautec.api.blockentities.multiblock.MultiblockEntity;
import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.api.multiblocks.MultiblockData;
import com.portingdeadmods.nautec.api.multiblocks.MultiblockLayer;
import com.portingdeadmods.nautec.api.utils.HorizontalDirection;
import com.portingdeadmods.nautec.content.blocks.multiblock.part.AugmentationStationExtensionBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.part.AugmentationStationPartBlock;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.registries.NTBlocks;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class AugmentationStationMultiblock
implements Multiblock {
    public static final IntegerProperty AS_PART = IntegerProperty.create((String)"as_part", (int)0, (int)8);
    private int actualIndex = 0;

    @Override
    public Block getUnformedController() {
        return (Block)NTBlocks.AUGMENTATION_STATION.get();
    }

    @Override
    public Block getFormedController() {
        return (Block)NTBlocks.AUGMENTATION_STATION.get();
    }

    @Override
    public MultiblockLayer[] getLayout() {
        return new MultiblockLayer[]{this.layer(0, 0, 3, 0, 0, 0, 4, 2, 4, 0, 3, 2, 1, 2, 3, 0, 4, 2, 4, 0, 0, 0, 3, 0, 0)};
    }

    @Override
    public Int2ObjectMap<Block> getDefinition() {
        Int2ObjectOpenHashMap def = new Int2ObjectOpenHashMap();
        def.put(0, null);
        def.put(1, (Object)this.getUnformedController());
        def.put(2, (Object)((Block)NTBlocks.POLISHED_PRISMARINE.get()));
        def.put(3, (Object)((Block)NTBlocks.AUGMENTATION_STATION_EXTENSION.get()));
        def.put(4, (Object)((Block)NTBlocks.AQUARINE_STEEL_BLOCK.get()));
        return def;
    }

    @Override
    public BlockEntityType<? extends MultiblockEntity> getMultiBlockEntityType() {
        return NTBlockEntityTypes.AUGMENTATION_STATION.get();
    }

    @Override
    public void onStartForming(Level level, BlockPos firstPos, BlockPos controllerPos) {
        this.actualIndex = 0;
    }

    @Override
    public void onStartUnforming(Level level, BlockPos firstPos, BlockPos controllerPos) {
        this.actualIndex = 0;
    }

    @Override
    public void iterBlock(Level level, BlockPos blockPos, BlockPos controllerPos, int layerIndex, int layoutIndex, MultiblockData data, boolean forming) {
        int[] curLayer;
        Int2ObjectMap<Block> def = this.getDefinition();
        Block block = (Block)def.get((curLayer = this.getLayout()[0].layer())[layerIndex]);
        if (block == this.getUnformedController() || block == NTBlocks.POLISHED_PRISMARINE.get() || block == NTBlocks.AQUARINE_STEEL_BLOCK.get()) {
            ++this.actualIndex;
        }
    }

    @Override
    @Nullable
    public BlockState formBlock(Level level, BlockPos blockPos, BlockPos controllerPos, int layerIndex, int layoutIndex, MultiblockData multiblockData, @Nullable Player player) {
        int[] curLayer;
        Int2ObjectMap<Block> def = this.getDefinition();
        Block block = (Block)def.get((curLayer = this.getLayout()[0].layer())[layerIndex]);
        if (block == this.getUnformedController() || block == NTBlocks.POLISHED_PRISMARINE.get() || block == NTBlocks.AQUARINE_STEEL_BLOCK.get()) {
            if (this.actualIndex == 4) {
                return (BlockState)((BlockState)this.getFormedController().defaultBlockState().setValue((Property)FORMED, (Comparable)Boolean.valueOf(true))).setValue((Property)AS_PART, (Comparable)Integer.valueOf(this.actualIndex));
            }
            return (BlockState)((BlockState)((AugmentationStationPartBlock)((Object)NTBlocks.AUGMENTATION_STATION_PART.get())).defaultBlockState().trySetValue((Property)FORMED, (Comparable)Boolean.valueOf(true))).trySetValue((Property)AS_PART, (Comparable)Integer.valueOf(this.actualIndex));
        }
        if (layerIndex == 2 || layerIndex == 10 || layerIndex == 14 || layerIndex == 22) {
            return (BlockState)((BlockState)((AugmentationStationExtensionBlock)NTBlocks.AUGMENTATION_STATION_EXTENSION.get()).defaultBlockState().setValue((Property)FORMED, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)this.indexToDir(layerIndex));
        }
        return null;
    }

    private Direction indexToDir(int index) {
        return switch (index) {
            case 2 -> Direction.EAST;
            case 10 -> Direction.NORTH;
            case 14 -> Direction.SOUTH;
            case 22 -> Direction.WEST;
            default -> null;
        };
    }

    @Override
    public boolean isFormed(Level level, BlockPos blockPos) {
        BlockState blockState = level.getBlockState(blockPos);
        return blockState.hasProperty((Property)FORMED) && (Boolean)blockState.getValue((Property)FORMED) != false;
    }

    @Override
    @Nullable
    public HorizontalDirection getFixedDirection() {
        return HorizontalDirection.EAST;
    }
}

