/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.menus;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class AugmentationViewerScreen
extends Screen {
    private final int imageWidth;
    private final int imageHeight;
    private int leftPos;
    private int topPos;
    private final Player player;
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"textures/gui/augments.png");

    public AugmentationViewerScreen(Component title, Player player) {
        super(title);
        this.player = player;
        this.imageWidth = 202;
        this.imageHeight = 160;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int scale = 30;
        int x1 = this.leftPos + 10;
        int y1 = this.topPos + 40;
        int x2 = x1 + 75;
        int y2 = y1 + 75;
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)x1, (int)y1, (int)x2, (int)y2, (int)scale, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.player);
        Map<AugmentSlot, Augment> augments = AugmentHelper.getAugments(this.player);
        int y = y1 - 40;
        ArrayList<AugmentSlot> emptySlots = new ArrayList<AugmentSlot>();
        ArrayList<AugmentSlot> fullSlots = new ArrayList<AugmentSlot>();
        for (AugmentSlot augmentSlot : augments.keySet()) {
            Augment augment = augments.get(augmentSlot);
            if (augment == null) {
                emptySlots.add(augmentSlot);
                continue;
            }
            fullSlots.add(augmentSlot);
        }
        for (AugmentSlot slot : fullSlots) {
            this.displayAugment(guiGraphics, slot, augments.get(slot), x2, y += 20);
        }
        for (AugmentSlot slot : emptySlots) {
            this.displayAugment(guiGraphics, slot, augments.get(slot), x2, y += 20);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void displayAugment(GuiGraphics graphics, AugmentSlot slot, Augment aug, int x, int y) {
        graphics.drawString(this.font, (Component)Component.translatable((String)("augment_slot.nautec." + slot.getName())).append((Component)Component.literal((String)":")), x, y, 0);
        graphics.drawString(this.font, (Component)(aug == null ? Component.literal((String)"    No Augment in slot") : Component.literal((String)"    ").append((Component)Component.translatable((String)("augment_type." + aug.getAugmentType().toString())))), x, y + 10, 0);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }
}

