/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items.tools;

import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.content.blocks.LaserJunctionBlock;
import com.portingdeadmods.nautec.utils.BlockUtils;
import com.portingdeadmods.nautec.utils.MultiblockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class AquarineWrenchItem
extends Item {
    public AquarineWrenchItem(Item.Properties properties) {
        super(properties);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        BlockState blockState;
        Level level = useOnContext.getLevel();
        BlockPos pos = useOnContext.getClickedPos();
        BlockState controllerState = blockState = level.getBlockState(pos);
        Player player = useOnContext.getPlayer();
        if (blockState.getBlock() instanceof LaserJunctionBlock && blockState.hasProperty(LaserJunctionBlock.CONNECTION[0])) {
            Direction direction = AquarineWrenchItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getDirection();
            LaserJunctionBlock.ConnectionType newType = switch ((LaserJunctionBlock.ConnectionType)((Object)blockState.getValue(LaserJunctionBlock.CONNECTION[direction.ordinal()]))) {
                default -> throw new MatchException(null, null);
                case LaserJunctionBlock.ConnectionType.INPUT -> {
                    if (player.isShiftKeyDown()) {
                        yield LaserJunctionBlock.ConnectionType.OUTPUT;
                    }
                    yield LaserJunctionBlock.ConnectionType.NONE;
                }
                case LaserJunctionBlock.ConnectionType.OUTPUT -> {
                    if (player.isShiftKeyDown()) {
                        yield LaserJunctionBlock.ConnectionType.NONE;
                    }
                    yield LaserJunctionBlock.ConnectionType.INPUT;
                }
                case LaserJunctionBlock.ConnectionType.NONE -> player.isShiftKeyDown() ? LaserJunctionBlock.ConnectionType.OUTPUT : LaserJunctionBlock.ConnectionType.INPUT;
            };
            level.setBlockAndUpdate(pos, (BlockState)blockState.setValue(LaserJunctionBlock.CONNECTION[direction.ordinal()], (Comparable)((Object)newType)));
            return InteractionResult.SUCCESS;
        }
        if (!useOnContext.getPlayer().isCrouching()) {
            for (Multiblock multiblock : NTRegistries.MULTIBLOCK) {
                if (!controllerState.is(multiblock.getUnformedController())) continue;
                try {
                    if (MultiblockHelper.form(multiblock, pos, level, useOnContext.getPlayer())) {
                        return InteractionResult.SUCCESS;
                    }
                    break;
                }
                catch (Exception e) {
                    Nautec.LOGGER.error("Encountered err forming multiblock", (Throwable)e);
                }
            }
            for (Property prop : blockState.getProperties()) {
                if (!(prop instanceof DirectionProperty)) continue;
                DirectionProperty directionProperty = (DirectionProperty)prop;
                if (!prop.getName().equals("facing")) continue;
                BlockState rotatedState = BlockUtils.rotateBlock(blockState, directionProperty, blockState.getValue((Property)directionProperty));
                level.setBlock(pos, rotatedState, 3);
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ROTATE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }
}

