/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items.tools;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.content.items.tiers.NTToolMaterials;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.NTDataComponentsUtils;
import com.portingdeadmods.nautec.data.components.ComponentPowerStorage;
import com.portingdeadmods.nautec.utils.ItemUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AquarineSwordItem
extends SwordItem
implements IPowerItem {
    public static final AttributeModifier ENABLED_DAMAGE = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"damage"), 0.7, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final AttributeModifier DISABLED_DAMAGE = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"damage"), 0.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public AquarineSwordItem() {
        super(NTToolMaterials.AQUARINE, new Item.Properties().attributes(SwordItem.createAttributes((Tier)NTToolMaterials.AQUARINE, (int)3, (float)-2.4f)).component(NTDataComponents.IS_INFUSED, (Object)false).component(NTDataComponents.ABILITY_ENABLED, (Object)false).component(NTDataComponents.POWER, (Object)ComponentPowerStorage.withCapacity(1200)));
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        if (powerStorage.getPowerStored() <= 0) {
            return InteractionResult.FAIL;
        }
        return super.useOn(context);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        IPowerStorage powerStorage = (IPowerStorage)miningEntity.getItemInHand(InteractionHand.MAIN_HAND).getCapability(NTCapabilities.PowerStorage.ITEM);
        powerStorage.tryDrainPower(1, false);
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (NTDataComponentsUtils.isAbilityEnabled(stack).booleanValue()) {
            IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
            ItemAttributeModifiers attributes = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            boolean hasEnergy = powerStorage.getPowerStored() > 0;
            attributes = attributes.withModifierAdded(Attributes.ATTACK_DAMAGE, hasEnergy ? ENABLED_DAMAGE : DISABLED_DAMAGE, EquipmentSlotGroup.MAINHAND);
            stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)attributes);
        } else {
            ItemAttributeModifiers attributes = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            attributes = attributes.withModifierAdded(Attributes.ATTACK_DAMAGE, DISABLED_DAMAGE, EquipmentSlotGroup.MAINHAND);
            stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)attributes);
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        IPowerStorage powerStorage = (IPowerStorage)attacker.getItemInHand(InteractionHand.MAIN_HAND).getCapability(NTCapabilities.PowerStorage.ITEM);
        if (NTDataComponentsUtils.isAbilityEnabled(stack).booleanValue()) {
            LightningBolt lightningBolt;
            powerStorage.tryDrainPower(10, false);
            if (!target.level().isClientSide && (lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(target.level())) != null) {
                lightningBolt.moveTo(target.getX(), target.getY(), target.getZ());
                target.level().addFreshEntity((Entity)lightningBolt);
                target.level().playSound(null, target.blockPosition(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.HOSTILE, 0.3f, 1.0f);
            }
        } else {
            powerStorage.tryDrainPower(1, false);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isFoil(ItemStack stack) {
        return NTDataComponentsUtils.isAbilityEnabled(stack) != false || stack.isEnchanted();
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return ItemUtils.POWER_BAR_COLOR;
    }

    public int getBarWidth(ItemStack stack) {
        return ItemUtils.powerForDurabilityBar(stack);
    }

    @Override
    public int getMaxInput() {
        return 128;
    }

    @Override
    public int getMaxOutput() {
        return 100;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        tooltipComponents.add((Component)Component.literal((String)"Ability: Deal 70% more damage and spawn lightnings at targets").withStyle(ChatFormatting.DARK_PURPLE));
        if (!NTDataComponentsUtils.isInfused(stack).booleanValue()) {
            tooltipComponents.add((Component)Component.literal((String)"Infuse in Algae Serum to unlock Abilities").withStyle(ChatFormatting.DARK_GREEN));
        } else {
            tooltipComponents.add((Component)Component.literal((String)("Status: " + (NTDataComponentsUtils.isAbilityEnabled(stack) != false ? "Enabled" : "Shift + Right Click to Enable"))).withStyle(NTDataComponentsUtils.isAbilityEnabled(stack) != false ? ChatFormatting.GREEN : ChatFormatting.RED));
        }
        tooltipComponents.add((Component)Component.literal((String)("Power: " + powerStorage.getPowerStored() + "/" + powerStorage.getPowerCapacity() + " AP")).withStyle(ChatFormatting.DARK_AQUA));
    }
}

