/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items.tools;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.content.items.tiers.NTToolMaterials;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.NTDataComponentsUtils;
import com.portingdeadmods.nautec.data.components.ComponentPowerStorage;
import com.portingdeadmods.nautec.utils.ItemUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class AquarineHoeItem
extends HoeItem
implements IPowerItem {
    private static final int POWER_PER_BLOCK = 2;

    public AquarineHoeItem() {
        super(NTToolMaterials.AQUARINE, new Item.Properties().stacksTo(1).component(NTDataComponents.ABILITY_ENABLED, (Object)false).component(NTDataComponents.IS_INFUSED, (Object)false).component(NTDataComponents.POWER, (Object)ComponentPowerStorage.withCapacity(700)).attributes(HoeItem.createAttributes((Tier)NTToolMaterials.AQUARINE, (float)0.0f, (float)-3.0f)));
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        if (powerStorage.getPowerStored() <= 0) {
            return InteractionResult.FAIL;
        }
        if (context.getPlayer() != null && NTDataComponentsUtils.isAbilityEnabled(stack).booleanValue() && this.canTill(context.getLevel(), context.getClickedPos(), context.getLevel().getBlockState(context.getClickedPos()))) {
            this.createFarmland3x3(context.getLevel(), context.getClickedPos(), context.getPlayer(), stack);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private void createFarmland3x3(Level level, BlockPos center, Player player, ItemStack stack) {
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        int availablePower = powerStorage.getPowerStored();
        int blocksToTill = availablePower / 2;
        for (BlockPos targetPos : BlockPos.betweenClosed((BlockPos)center.offset(-1, 0, -1), (BlockPos)center.offset(1, 0, 1))) {
            BlockState targetState = level.getBlockState(targetPos);
            if (blocksToTill <= 0 || !this.canTill(level, targetPos, targetState)) continue;
            this.tillBlock(level, targetPos, player, stack, powerStorage);
            --blocksToTill;
        }
        if (level.isClientSide) {
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean canTill(Level level, BlockPos pos, BlockState state) {
        return state.is(BlockTags.DIRT) || state.is(Blocks.GRASS_BLOCK);
    }

    private void tillBlock(Level level, BlockPos pos, Player player, ItemStack stack, IPowerStorage powerStorage) {
        BlockState currentState = level.getBlockState(pos);
        if (currentState.is(BlockTags.DIRT) || currentState.is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.FARMLAND.defaultBlockState(), 3);
            powerStorage.tryDrainPower(2, false);
        }
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        IPowerStorage powerStorage = (IPowerStorage)miningEntity.getItemInHand(InteractionHand.MAIN_HAND).getCapability(NTCapabilities.PowerStorage.ITEM);
        powerStorage.tryDrainPower(1, false);
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        IPowerStorage powerStorage = (IPowerStorage)attacker.getItemInHand(InteractionHand.MAIN_HAND).getCapability(NTCapabilities.PowerStorage.ITEM);
        powerStorage.tryDrainPower(1, false);
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return ItemUtils.POWER_BAR_COLOR;
    }

    public int getBarWidth(ItemStack stack) {
        return ItemUtils.powerForDurabilityBar(stack);
    }

    @Override
    public int getMaxInput() {
        return 128;
    }

    @Override
    public int getMaxOutput() {
        return 100;
    }

    public boolean isFoil(ItemStack stack) {
        return NTDataComponentsUtils.isAbilityEnabled(stack) != false || stack.isEnchanted();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        tooltipComponents.add((Component)Component.literal((String)"Ability: Till 3x3 Farmland").withStyle(ChatFormatting.DARK_PURPLE));
        if (!NTDataComponentsUtils.isInfused(stack).booleanValue()) {
            tooltipComponents.add((Component)Component.literal((String)"Infuse in Algae Serum to unlock Abilities").withStyle(ChatFormatting.DARK_GREEN));
        } else {
            tooltipComponents.add((Component)Component.literal((String)("Status: " + (NTDataComponentsUtils.isAbilityEnabled(stack) != false ? "Enabled" : "Shift + Right Click to Enable"))).withStyle(NTDataComponentsUtils.isAbilityEnabled(stack) != false ? ChatFormatting.GREEN : ChatFormatting.RED));
        }
        tooltipComponents.add((Component)Component.literal((String)("Power: " + powerStorage.getPowerStored() + "/" + powerStorage.getPowerCapacity() + " AP")).withStyle(ChatFormatting.DARK_AQUA));
    }
}

