/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items.tools;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.content.items.tiers.NTToolMaterials;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.NTDataComponentsUtils;
import com.portingdeadmods.nautec.data.components.ComponentPowerStorage;
import com.portingdeadmods.nautec.utils.ItemUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AquarineAxeItem
extends AxeItem
implements IPowerItem {
    private static final int POWER_PER_BLOCK = 2;

    public AquarineAxeItem() {
        super(NTToolMaterials.AQUARINE, new Item.Properties().stacksTo(1).component(NTDataComponents.IS_INFUSED, (Object)false).component(NTDataComponents.POWER, (Object)ComponentPowerStorage.withCapacity(1200)).component(NTDataComponents.ABILITY_ENABLED, (Object)false).attributes(AxeItem.createAttributes((Tier)NTToolMaterials.AQUARINE, (float)3.0f, (float)-3.0f)));
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        if (powerStorage.getPowerStored() <= 0) {
            return InteractionResult.FAIL;
        }
        return super.useOn(context);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        IPowerStorage powerStorage = (IPowerStorage)miningEntity.getItemInHand(InteractionHand.MAIN_HAND).getCapability(NTCapabilities.PowerStorage.ITEM);
        powerStorage.tryDrainPower(1, false);
        if (NTDataComponentsUtils.isAbilityEnabled(stack).booleanValue()) {
            this.chopTree(level, pos, miningEntity, stack);
            return true;
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        IPowerStorage powerStorage = (IPowerStorage)attacker.getItemInHand(InteractionHand.MAIN_HAND).getCapability(NTCapabilities.PowerStorage.ITEM);
        powerStorage.tryDrainPower(1, false);
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isFoil(ItemStack stack) {
        return NTDataComponentsUtils.isAbilityEnabled(stack) != false || stack.isEnchanted();
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return ItemUtils.POWER_BAR_COLOR;
    }

    public int getBarWidth(ItemStack stack) {
        return ItemUtils.powerForDurabilityBar(stack);
    }

    @Override
    public int getMaxInput() {
        return 128;
    }

    @Override
    public int getMaxOutput() {
        return 100;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.literal((String)"Ability: Chop Down Entire Trees").withStyle(ChatFormatting.DARK_PURPLE));
        if (!NTDataComponentsUtils.isInfused(stack).booleanValue()) {
            tooltipComponents.add((Component)Component.literal((String)"Infuse in Algae Serum to unlock Abilities").withStyle(ChatFormatting.DARK_GREEN));
        } else {
            tooltipComponents.add((Component)Component.literal((String)("Status: " + (NTDataComponentsUtils.isAbilityEnabled(stack) != false ? "Enabled" : "Shift + Right Click to Enable"))).withStyle(NTDataComponentsUtils.isAbilityEnabled(stack) != false ? ChatFormatting.GREEN : ChatFormatting.RED));
        }
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        tooltipComponents.add((Component)Component.literal((String)("Power: " + powerStorage.getPowerStored() + "/" + powerStorage.getPowerCapacity() + " AP")).withStyle(ChatFormatting.DARK_AQUA));
    }

    private void chopTree(Level level, BlockPos pos, LivingEntity player, ItemStack stack) {
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        if (this.isLog(level, pos, level.getBlockState(pos)) && powerStorage.getPowerStored() > 0) {
            int blocksToBreak = powerStorage.getPowerStored() / 2;
            this.breakTree(level, pos, stack, player, powerStorage, blocksToBreak);
        }
    }

    private boolean isLog(Level level, BlockPos pos, BlockState state) {
        return state.is(BlockTags.LOGS) && level.getBlockEntity(pos) == null;
    }

    private int breakTree(Level level, BlockPos pos, ItemStack stack, LivingEntity player, IPowerStorage powerStorage, int blocksToBreak) {
        BlockState state = level.getBlockState(pos);
        if (!this.isLog(level, pos, state) || blocksToBreak <= 0 || powerStorage.getPowerStored() < 2) {
            return blocksToBreak;
        }
        level.destroyBlock(pos, true);
        powerStorage.tryDrainPower(2, false);
        --blocksToBreak;
        for (BlockPos adjacentPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            if (adjacentPos.equals((Object)pos) || blocksToBreak <= 0) continue;
            blocksToBreak = this.breakTree(level, adjacentPos, stack, player, powerStorage, blocksToBreak);
        }
        return blocksToBreak;
    }
}

