/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.content.items.tiers.NTArmorMaterials;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.components.ComponentPowerStorage;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.utils.ItemUtils;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class PrismMonocleItem
extends ArmorItem
implements IPowerItem {
    public PrismMonocleItem(Item.Properties properties) {
        super(NTArmorMaterials.PRISMARINE, ArmorItem.Type.HELMET, properties.component(NTDataComponents.POWER, (Object)ComponentPowerStorage.withCapacity(100)));
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.registerItem(CuriosCapability.ITEM, (stack, context) -> new ICurio(){

            public ItemStack getStack() {
                return NTItems.PRISM_MONOCLE.toStack();
            }

            public void curioTick(SlotContext slotContext) {
            }
        }, new ItemLike[]{(ItemLike)NTItems.PRISM_MONOCLE.get()});
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return ItemUtils.POWER_BAR_COLOR;
    }

    public int getBarWidth(ItemStack stack) {
        return ItemUtils.powerForDurabilityBar(stack);
    }

    @Override
    public int getMaxInput() {
        return 128;
    }

    @Override
    public int getMaxOutput() {
        return 0;
    }
}

