/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.NTDataComponentsUtils;
import com.portingdeadmods.nautec.data.components.ComponentPowerStorage;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.utils.ItemUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class BatteryItem
extends Item
implements IPowerItem {
    public BatteryItem(Item.Properties properties) {
        super(new Item.Properties().component(NTDataComponents.POWER, (Object)ComponentPowerStorage.withCapacity(10000)).component(NTDataComponents.ABILITY_ENABLED, (Object)false));
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.registerItem(CuriosCapability.ITEM, (stack, context) -> new ICurio((ItemStack)stack){
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
            }

            public ItemStack getStack() {
                return NTItems.PRISMATIC_BATTERY.toStack();
            }

            public void curioTick(SlotContext slotContext) {
                IPowerStorage powerStorage = (IPowerStorage)this.val$stack.getCapability(NTCapabilities.PowerStorage.ITEM);
                Player player = (Player)slotContext.entity();
                if (NTDataComponentsUtils.isAbilityEnabled(this.val$stack).booleanValue()) {
                    for (ItemStack itemStack : player.getInventory().items) {
                        IPowerStorage itemPowerStorage;
                        if (itemStack.getCapability(NTCapabilities.PowerStorage.ITEM) == null || (itemPowerStorage = (IPowerStorage)itemStack.getCapability(NTCapabilities.PowerStorage.ITEM)).getPowerStored() >= itemPowerStorage.getPowerCapacity()) continue;
                        int powerToTransfer = Math.min(powerStorage.getPowerStored(), itemPowerStorage.getPowerCapacity() - itemPowerStorage.getPowerStored());
                        powerStorage.tryDrainPower(powerToTransfer, false);
                        itemPowerStorage.tryFillPower(powerToTransfer, false);
                    }
                }
            }
        }, new ItemLike[]{(ItemLike)NTItems.PRISMATIC_BATTERY.get()});
    }

    public boolean isFoil(ItemStack stack) {
        return NTDataComponentsUtils.isAbilityEnabled(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return ItemUtils.POWER_BAR_COLOR;
    }

    public int getBarWidth(ItemStack stack) {
        return ItemUtils.powerForDurabilityBar(stack);
    }

    @Override
    public int getMaxInput() {
        return 128;
    }

    @Override
    public int getMaxOutput() {
        return 100;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        IPowerStorage powerStorage = (IPowerStorage)stack.getCapability(NTCapabilities.PowerStorage.ITEM);
        tooltipComponents.add((Component)Component.literal((String)("Status: " + (NTDataComponentsUtils.isAbilityEnabled(stack) != false ? "Enabled" : "Shift + Right Click to Enable"))).withStyle(NTDataComponentsUtils.isAbilityEnabled(stack) != false ? ChatFormatting.GREEN : ChatFormatting.RED));
        tooltipComponents.add((Component)Component.literal((String)("Power: " + powerStorage.getPowerStored() + "/" + powerStorage.getPowerCapacity() + " AP")).withStyle(ChatFormatting.DARK_AQUA));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

