/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.content.blockentities.CrateBlockEntity;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrateBlock
extends BaseEntityBlock {
    public CrateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{BlockStateProperties.OPEN}));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CrateBlock.simpleCodec(CrateBlock::new);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CrateBlockEntity be;
        block7: {
            block6: {
                if (level.isClientSide) {
                    return ItemInteractionResult.sidedSuccess((boolean)true);
                }
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof CrateBlockEntity)) break block6;
                be = (CrateBlockEntity)blockEntity;
                if (stack.is(NTItems.CROWBAR) && !((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue() && state.is((Block)NTBlocks.CRATE.get())) break block7;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.getCooldowns().isOnCooldown(stack.getItem())) {
            return ItemInteractionResult.FAIL;
        }
        RandomSource random = level.getRandom();
        if (random.nextInt(0, 7) == 0) {
            be.playSound(state, SoundEvents.ANVIL_HIT);
            player.getCooldowns().addCooldown(stack.getItem(), 10);
            return ItemInteractionResult.FAIL;
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true)));
        player.getCooldowns().addCooldown(stack.getItem(), 30);
        be.playSound(state, SoundEvents.ANVIL_USE);
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player.isSpectator()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrateBlockEntity) {
            CrateBlockEntity be = (CrateBlockEntity)blockEntity;
            if (((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
                player.openMenu((MenuProvider)be);
                player.awardStat(Stats.OPEN_BARREL);
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            } else {
                be.playSound(state, SoundEvents.CHEST_LOCKED);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.1875, (double)0.1875, (double)0.125, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.1875, (double)0.9375, (double)0.125, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.9375, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.125, (double)0.0625, (double)0.1875, (double)0.75, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.125, (double)0.0625, (double)0.9375, (double)0.75, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.125, (double)0.8125, (double)0.9375, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.125, (double)0.8125, (double)0.1875, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.OR);
        if (!((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.75, (double)0.1875, (double)0.8125, (double)0.8125, (double)0.8125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.75, (double)0.8125, (double)0.9375, (double)0.875, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.75, (double)0.1875, (double)0.1875, (double)0.875, (double)0.8125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.75, (double)0.0625, (double)0.9375, (double)0.875, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.75, (double)0.1875, (double)0.9375, (double)0.875, (double)0.8125), (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrateBlockEntity(pos, state);
    }

    @NotNull
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof CrateBlockEntity) {
            CrateBlockEntity be = (CrateBlockEntity)((Object)object);
            ItemStack stack = new ItemStack((ItemLike)this);
            be.saveToItem(stack, (HolderLookup.Provider)params.getLevel().registryAccess());
            return List.of(stack);
        }
        return super.getDrops(state, params);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof CrateBlockEntity) {
            ((CrateBlockEntity)blockentity).recheckOpen();
        }
    }
}

