/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.blocks.DisplayBlock;
import com.portingdeadmods.nautec.api.blocks.blockentities.LaserBlock;
import com.portingdeadmods.nautec.content.blockentities.AquaticCatalystBlockEntity;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.tags.NTTags;
import com.portingdeadmods.nautec.utils.ItemUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class AquaticCatalystBlock
extends LaserBlock
implements DisplayBlock {
    public static final BooleanProperty CORE_ACTIVE = BooleanProperty.create((String)"core_active");

    public AquaticCatalystBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)CORE_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return AquaticCatalystBlock.simpleCodec(AquaticCatalystBlock::new);
    }

    @Override
    public BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType() {
        return NTBlockEntityTypes.AQUATIC_CATALYST.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{BlockStateProperties.FACING, CORE_ACTIVE}));
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack.isEmpty()) {
            itemStack = player.getOffhandItem();
        }
        Direction direction = hitResult.getDirection();
        if (itemStack.isEmpty() && ((Boolean)state.getValue((Property)CORE_ACTIVE)).booleanValue() && direction == state.getValue((Property)BlockStateProperties.FACING)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORE_ACTIVE, (Comparable)Boolean.valueOf(false)));
            level.playLocalSound((Entity)player, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 0.75f);
            if (!player.isCreative()) {
                ItemUtils.giveItemToPlayerNoSound(player, Items.HEART_OF_THE_SEA.getDefaultInstance());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Direction direction = hitResult.getDirection();
        ItemStack itemStack = player.getItemInHand(hand);
        if (!((Boolean)state.getValue((Property)CORE_ACTIVE)).booleanValue() && itemStack.is(NTTags.Items.AQUATIC_CATALYST)) {
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue((Property)CORE_ACTIVE, (Comparable)Boolean.valueOf(true)));
            level.playLocalSound((Entity)player, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.hasInfiniteMaterials()) {
                itemStack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public List<Component> displayText(Level level, BlockPos blockPos, Player player) {
        BlockState blockState = level.getBlockState(blockPos);
        Direction direction = (Direction)blockState.getValue((Property)BlockStateProperties.FACING);
        boolean coreActive = (Boolean)blockState.getValue((Property)CORE_ACTIVE);
        AquaticCatalystBlockEntity be = (AquaticCatalystBlockEntity)level.getBlockEntity(blockPos);
        return List.of(Component.literal((String)("Active: " + String.valueOf(coreActive ? direction : "None"))).withStyle(ChatFormatting.WHITE), Component.literal((String)("Duration: " + be.getDuration())));
    }
}

