/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities.multiblock.part;

import com.google.common.collect.ImmutableMap;
import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.FakeBlockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.SavesControllerPosBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.blockentities.multiblock.controller.DrainBlockEntity;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class DrainPartBlockEntity
extends LaserBlockEntity
implements FakeBlockEntity,
SavesControllerPosBlockEntity {
    private BlockPos controllerPos;
    private Direction laserPort;

    public DrainPartBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.DRAIN_PART.get(), blockPos, blockState);
    }

    public void setLaserPort(Direction laserPort) {
        this.laserPort = laserPort;
    }

    public boolean hasLaserPort() {
        return this.laserPort != null;
    }

    public void open() {
        BlockEntity blockEntity;
        BlockPos actualBlockEntityPos = this.getActualBlockEntityPos();
        Nautec.LOGGER.debug("Attempt to open");
        if (actualBlockEntityPos != null && (blockEntity = this.level.getBlockEntity(actualBlockEntityPos)) instanceof DrainBlockEntity) {
            DrainBlockEntity drainBlockEntity = (DrainBlockEntity)blockEntity;
            drainBlockEntity.open();
        }
    }

    @Override
    public ObjectSet<Direction> getLaserInputs() {
        return ObjectSet.of((Object)this.laserPort);
    }

    @Override
    public ObjectSet<Direction> getLaserOutputs() {
        if (this.laserPort != null) {
            return ObjectSet.of((Object)this.laserPort.getOpposite());
        }
        return ObjectSet.of();
    }

    public <T> ImmutableMap<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return ImmutableMap.of();
    }

    @Override
    public boolean actualBlockEntity() {
        return false;
    }

    @Override
    @Nullable
    public BlockPos getActualBlockEntityPos() {
        return this.controllerPos;
    }

    @Override
    public void setControllerPos(BlockPos blockPos) {
        this.controllerPos = blockPos;
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        boolean hasControllerPos = tag.getBoolean("hasControllerPos");
        boolean hasLaserPort = tag.getBoolean("hasLaserPort");
        if (hasControllerPos) {
            this.controllerPos = BlockPos.of((long)tag.getLong("controllerPos"));
        }
        if (hasLaserPort) {
            this.laserPort = Direction.values()[tag.getInt("laserPort")];
        }
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.putBoolean("hasControllerPos", this.controllerPos != null);
        tag.putBoolean("hasLaserPort", this.laserPort != null);
        if (this.controllerPos != null) {
            tag.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.laserPort != null) {
            tag.putInt("laserPort", this.laserPort.ordinal());
        }
    }

    @Override
    public void commonTick() {
        super.commonTick();
        this.transmitPower(this.getPower());
    }
}

