/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities.multiblock.part;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.MultiblockPartEntity;
import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.blockentities.multiblock.controller.AugmentationStationBlockEntity;
import com.portingdeadmods.nautec.content.items.RobotArmItem;
import com.portingdeadmods.nautec.content.menus.AugmentationStationExtensionMenu;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.registries.NTItems;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AugmentationStationExtensionBlockEntity
extends LaserBlockEntity
implements MultiblockPartEntity,
MenuProvider {
    private float middleIndependentAngle;
    public float tipIndependentAngle;
    private int robotArmSpeed;
    private boolean animationRunning;
    private int animationTime;
    private int animationInterval;
    private Animation animation;
    private BlockPos controllerPos;

    public AugmentationStationExtensionBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.AUGMENTATION_STATION_EXTENSION.get(), blockPos, blockState);
        this.addItemHandler(2, 1, (slot, stack) -> slot == 1 && stack.getItem() instanceof RobotArmItem || slot == 0);
        this.animation = Animation.IDLE;
    }

    public void equipAugment() {
        this.animationTime = 50;
        this.robotArmSpeed = 7;
        this.animation = Animation.FORWARD;
        this.animationRunning = true;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void commonTick() {
        super.commonTick();
        if (this.animationInterval > 0) {
            --this.animationInterval;
            if (this.animation == Animation.BACKWARD && this.animationInterval == 35) {
                this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS);
            }
        } else if (this.animationTime > 0) {
            --this.animationTime;
            float oldMiddleAngle = this.middleIndependentAngle;
            this.middleIndependentAngle += (float)(this.robotArmSpeed * 10) / 3.0f * 0.25f;
            this.tipIndependentAngle += (this.middleIndependentAngle - oldMiddleAngle) * 1.5f;
            if (this.animation == Animation.FORWARD && this.animationTime == 0) {
                this.animationInterval = 40;
                this.animationTime = 50;
                this.robotArmSpeed = -7;
                this.animation = Animation.BACKWARD;
            }
            if (this.animation == Animation.BACKWARD && this.animationTime == 0) {
                this.animation = Animation.IDLE;
                this.animationRunning = false;
            }
        }
    }

    @Override
    protected void onItemsChanged(int slot) {
        BlockPos controllerPos1;
        BlockEntity blockEntity;
        super.onItemsChanged(slot);
        IItemHandler handler = this.getItemHandler();
        if (this.isFormed().booleanValue() && (blockEntity = this.level.getBlockEntity(controllerPos1 = this.getControllerPos())) instanceof AugmentationStationBlockEntity) {
            AugmentationStationBlockEntity be = (AugmentationStationBlockEntity)blockEntity;
            if (!handler.getStackInSlot(1).isEmpty()) {
                be.getAugmentItems().put(this.worldPosition, handler.getStackInSlot(0));
            } else if (be.getAugmentItems().containsKey(this.worldPosition)) {
                be.getAugmentItems().remove(this.worldPosition);
            }
        }
    }

    @NotNull
    private Boolean isFormed() {
        return (Boolean)this.getBlockState().getValue((Property)Multiblock.FORMED);
    }

    public ItemStack getAugmentItem() {
        if (this.getItemHandler().getStackInSlot(1).is(NTItems.CLAW_ROBOT_ARM)) {
            return this.getItemHandler().getStackInSlot(0);
        }
        return ItemStack.EMPTY;
    }

    public float getMiddleIndependentAngle(float partialTicks) {
        return this.animationRunning ? (this.middleIndependentAngle + partialTicks) / 360.0f : 0.0f;
    }

    public float getTipIndependentAngle(float partialTicks) {
        return this.animationRunning ? (this.tipIndependentAngle + partialTicks) / 360.0f : 0.0f;
    }

    @Override
    public ObjectSet<Direction> getLaserInputs() {
        return ObjectSet.of((Object)Direction.DOWN);
    }

    @Override
    public ObjectSet<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Override
    public void setControllerPos(BlockPos blockPos) {
        this.controllerPos = blockPos;
    }

    public void onLoad() {
        super.onLoad();
        this.onItemsChanged(0);
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.controllerPos = BlockPos.of((long)tag.getLong("controllerPos"));
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        if (this.controllerPos != null) {
            tag.putLong("controllerPos", this.controllerPos.asLong());
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"Augmentation Station Extension");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new AugmentationStationExtensionMenu(containerId, playerInventory, this);
    }

    public static enum Animation {
        FORWARD,
        BACKWARD,
        IDLE;

    }
}

