/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities.multiblock.controller;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.api.augments.AugmentType;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.MultiblockEntity;
import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.api.multiblocks.MultiblockData;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.blockentities.multiblock.part.AugmentationStationExtensionBlockEntity;
import com.portingdeadmods.nautec.content.recipes.AugmentationRecipe;
import com.portingdeadmods.nautec.content.recipes.inputs.AugmentationRecipeInput;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import com.portingdeadmods.nautec.utils.PlayerUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AugmentationStationBlockEntity
extends ContainerBlockEntity
implements MultiblockEntity {
    private MultiblockData multiblockData = MultiblockData.EMPTY;
    private UUID playerUUID;
    private int playerOpenMenuInterval;
    private final Map<BlockPos, ItemStack> augmentItems = new HashMap<BlockPos, ItemStack>();
    private boolean isRunning;
    private int duration;
    private Player player = null;
    private AugmentationRecipe recipe;
    private AugmentSlot slot;
    private double prevSpeed;
    private double prevJumpStrength;

    public AugmentationStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.AUGMENTATION_STATION.get(), blockPos, blockState);
    }

    public Map<BlockPos, ItemStack> getAugmentItems() {
        return this.augmentItems;
    }

    public void startAugmentation(Player player, AugmentSlot augmentSlot) {
        Optional<AugmentationRecipe> recipe;
        if (!this.isRunning && (recipe = this.getRecipe()).isPresent()) {
            for (BlockPos pos : this.augmentItems.keySet()) {
                AugmentationStationExtensionBlockEntity be = (AugmentationStationExtensionBlockEntity)this.level.getBlockEntity(pos);
                if (be.getPower() < NTConfig.augmentationStationPower) {
                    return;
                }
                be.equipAugment();
            }
            AttributeMap attributes = player.getAttributes();
            this.prevSpeed = attributes.getBaseValue(Attributes.MOVEMENT_SPEED);
            this.prevJumpStrength = attributes.getBaseValue(Attributes.JUMP_STRENGTH);
            attributes.getInstance(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
            attributes.getInstance(Attributes.JUMP_STRENGTH).setBaseValue(0.0);
            this.isRunning = true;
            this.duration = 80;
            this.player = player;
            this.recipe = recipe.get();
            this.slot = augmentSlot;
        }
    }

    @NotNull
    public Optional<AugmentationRecipe> getRecipe() {
        List<ItemStack> ingredients = this.collectInputItems();
        return this.level.getRecipeManager().getRecipeFor((RecipeType)AugmentationRecipe.Type.INSTANCE, (RecipeInput)new AugmentationRecipeInput(ingredients, 100), this.level).map(RecipeHolder::value);
    }

    public void restorePlayerAttributes() {
        AttributeMap attributes = this.player.getAttributes();
        attributes.getInstance(Attributes.MOVEMENT_SPEED).setBaseValue(this.prevSpeed);
        attributes.getInstance(Attributes.JUMP_STRENGTH).setBaseValue(this.prevJumpStrength);
    }

    @Override
    public void commonTick() {
        super.commonTick();
        if (this.isFormed().booleanValue()) {
            if (!this.isRunning) {
                List players = this.level.getEntitiesOfClass(Player.class, new AABB(this.worldPosition.above()));
                if (players.isEmpty()) {
                    this.playerUUID = null;
                    return;
                }
                Player player = (Player)players.getFirst();
                UUID uuid = player.getUUID();
                if (this.playerUUID == null) {
                    this.playerUUID = uuid;
                    this.playerOpenMenuInterval = 10;
                }
                if (this.playerUUID.equals(uuid)) {
                    if (this.playerOpenMenuInterval > 0) {
                        --this.playerOpenMenuInterval;
                        if (this.playerOpenMenuInterval == 0 && player.level().isClientSide()) {
                            PlayerUtils.openAugmentationStationScreen(player, this, (Component)Component.literal((String)"Augmentation Station"));
                        }
                    }
                } else {
                    this.playerUUID = null;
                }
            } else if (this.duration > 0) {
                --this.duration;
                for (BlockPos pos : this.augmentItems.keySet()) {
                    AugmentationStationExtensionBlockEntity be = (AugmentationStationExtensionBlockEntity)this.level.getBlockEntity(pos);
                    if (be.getPower() >= NTConfig.augmentationStationPower) continue;
                    this.duration = 0;
                    this.isRunning = false;
                    this.restorePlayerAttributes();
                    return;
                }
                if (this.duration == 0) {
                    this.isRunning = false;
                    AugmentType<?> type = this.recipe.resultAugment();
                    Object augment = type.create(this.slot);
                    ((Augment)augment).setPlayer(this.player);
                    AugmentHelper.setAugment(this.player, this.slot, augment);
                    for (BlockPos pos : this.augmentItems.keySet()) {
                        AugmentationStationExtensionBlockEntity be = (AugmentationStationExtensionBlockEntity)this.level.getBlockEntity(pos);
                        be.getItemHandler().extractItem(0, 1, false);
                    }
                    this.restorePlayerAttributes();
                }
            }
        }
    }

    private List<ItemStack> collectInputItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Direction direction : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
            BlockPos pos = this.worldPosition.relative(direction, 2);
            AugmentationStationExtensionBlockEntity be = (AugmentationStationExtensionBlockEntity)this.level.getBlockEntity(pos);
            ItemStack augmentItem = be.getAugmentItem();
            if (augmentItem.isEmpty()) continue;
            this.augmentItems.put(pos, augmentItem);
            items.add(augmentItem);
        }
        return items;
    }

    @NotNull
    private Boolean isFormed() {
        return (Boolean)this.getBlockState().getValue((Property)Multiblock.FORMED);
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public MultiblockData getMultiblockData() {
        return this.multiblockData;
    }

    @Override
    public void setMultiblockData(MultiblockData data) {
        this.multiblockData = data;
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.multiblockData = this.loadMBData(tag.getCompound("multiblockData"));
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.put("multiblockData", (Tag)this.saveMBData());
    }
}

