/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.blocks.LaserJunctionBlock;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class LaserJunctionBlockEntity
extends LaserBlockEntity {
    public LaserJunctionBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.LASER_JUNCTION.get(), blockPos, blockState);
    }

    @Override
    public ObjectSet<Direction> getLaserInputs() {
        return this.getConnections(LaserJunctionBlock.ConnectionType.INPUT);
    }

    public String getLaserInputsAsString() {
        ObjectSet<Direction> inputs = this.getLaserInputs();
        if (inputs.isEmpty()) {
            return "No inputs";
        }
        return inputs.stream().map(direction -> StringUtils.capitalizeFirstLetter((String)direction.getName())).reduce((a, b) -> a + ", " + b).orElse("");
    }

    @Override
    public ObjectSet<Direction> getLaserOutputs() {
        return this.getConnections(LaserJunctionBlock.ConnectionType.OUTPUT);
    }

    public String getLaserOutputsAsString() {
        ObjectSet<Direction> outputs = this.getLaserOutputs();
        if (outputs.isEmpty()) {
            return "No outputs";
        }
        return outputs.stream().map(direction -> StringUtils.capitalizeFirstLetter((String)direction.getName())).reduce((a, b) -> a + ", " + b).orElse("");
    }

    private ObjectSet<Direction> getConnections(LaserJunctionBlock.ConnectionType type) {
        ObjectArraySet connections = new ObjectArraySet();
        for (Direction direction : Direction.values()) {
            if (this.getBlockState().getValue(LaserJunctionBlock.CONNECTION[direction.get3DDataValue()]) != type) continue;
            connections.add((Object)direction);
        }
        return connections;
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        this.transmitPower(this.power);
    }
}

