/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.utils.ParticleUtils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ChargerBlockEntity
extends LaserBlockEntity {
    public ChargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.CHARGER.get(), blockPos, blockState);
        this.addItemHandler(1);
    }

    @Override
    public ObjectSet<Direction> getLaserInputs() {
        return ObjectSet.of((Object[])Direction.values());
    }

    @Override
    public ObjectSet<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public void commonTick() {
        IItemHandler itemHandler;
        Item item;
        super.commonTick();
        if (this.getPower() > 0 && (item = (itemHandler = this.getItemHandler()).getStackInSlot(0).getItem()) instanceof IPowerItem) {
            IPowerItem powerItem = (IPowerItem)item;
            IPowerStorage powerStorage = (IPowerStorage)itemHandler.getStackInSlot(0).getCapability(NTCapabilities.PowerStorage.ITEM);
            if (powerStorage.getPowerStored() < powerStorage.getPowerCapacity()) {
                powerStorage.tryFillPower(4, false);
                ParticleUtils.spawnParticlesAroundBlock(this.getBlockPos(), this.getLevel(), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK);
            }
        }
    }
}

