/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.blocks.AquaticCatalystBlock;
import com.portingdeadmods.nautec.content.recipes.AquaticCatalystChannelingRecipe;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.utils.SidedCapUtils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public class AquaticCatalystBlockEntity
extends LaserBlockEntity {
    private AquaticCatalystChannelingRecipe recipe;
    private int amount;
    private int duration;

    public AquaticCatalystBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.AQUATIC_CATALYST.get(), blockPos, blockState);
        this.addItemHandler(1, (slot, stack) -> this.hasRecipe((ItemStack)stack));
    }

    private boolean hasRecipe(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)AquaticCatalystChannelingRecipe.Type.INSTANCE, (RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    @Override
    public ObjectSet<Direction> getLaserInputs() {
        return ObjectSet.of();
    }

    public int getDuration() {
        return this.duration;
    }

    public int getRemainingDuration() {
        return this.recipe != null ? this.recipe.duration() - this.duration : 0;
    }

    public ItemStack getProcessingItem() {
        return this.getItemHandler().getStackInSlot(0);
    }

    public Optional<AquaticCatalystChannelingRecipe> getCurrentRecipe() {
        return Optional.ofNullable(this.recipe);
    }

    @Override
    public ObjectSet<Direction> getLaserOutputs() {
        Direction direction = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        boolean coreActive = this.isActive();
        if (coreActive) {
            return ObjectSet.of((Object)direction.getOpposite());
        }
        return ObjectSet.of();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        ItemStack stack = this.getItemHandler().getStackInSlot(0);
        if (!stack.isEmpty() && this.isActive()) {
            if (this.recipe == null) {
                Optional<AquaticCatalystChannelingRecipe> recipe1 = this.level.getRecipeManager().getRecipeFor((RecipeType)AquaticCatalystChannelingRecipe.Type.INSTANCE, (RecipeInput)new SingleRecipeInput(stack), this.level).map(RecipeHolder::value);
                if (recipe1.isPresent()) {
                    this.recipe = recipe1.get();
                } else {
                    return;
                }
            }
            Direction direction = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
            if (this.getLaserDistances().getInt((Object)direction.getOpposite()) > 0) {
                if (this.duration >= this.recipe.duration()) {
                    this.getItemStackHandler().setStackInSlot(0, stack.copyWithCount(stack.getCount() - 1));
                    this.duration = 0;
                } else {
                    this.amount = this.recipe.powerAmount() / this.recipe.duration();
                    this.transmitPower(this.amount);
                    this.setPurity(this.recipe.purity());
                    ++this.duration;
                }
            }
        } else {
            this.recipe = null;
        }
    }

    @Override
    public int getPower() {
        return this.amount;
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        if (capability == Capabilities.ItemHandler.BLOCK) {
            return SidedCapUtils.allInsert(0);
        }
        return Map.of();
    }

    public boolean isActive() {
        return (Boolean)this.getBlockState().getValue((Property)AquaticCatalystBlock.CORE_ACTIVE);
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.duration = tag.getInt("duration");
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.putInt("duration", this.duration);
    }
}

