/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.augments;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.network.KeyPressedPayload;
import com.portingdeadmods.nautec.registries.NTAugments;
import com.portingdeadmods.nautec.registries.NTKeybinds;
import java.util.ArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ThrowRandomPotionAugments
extends Augment {
    public ThrowRandomPotionAugments(AugmentSlot augmentSlot) {
        super(NTAugments.THROW_POTION_AUGMENT.get(), augmentSlot);
    }

    @Override
    public void clientTick(PlayerTickEvent.Post event) {
        if (((KeyMapping)NTKeybinds.THROW_POTION_KEYBIND.get()).consumeClick() && !this.isOnCooldown()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new KeyPressedPayload(this.augmentSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.handleKeybindPress();
        }
    }

    @Override
    public void handleKeybindPress() {
        ArrayList<Holder> potions = new ArrayList<Holder>();
        potions.add(Potions.HEALING);
        potions.add(Potions.HARMING);
        potions.add(Potions.REGENERATION);
        potions.add(Potions.SWIFTNESS);
        potions.add(Potions.SLOWNESS);
        Holder randomPotion = (Holder)potions.get(this.player.getRandom().nextInt(potions.size()));
        ItemStack stack = PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)randomPotion);
        ThrownPotion potion = new ThrownPotion(this.player.level(), (LivingEntity)this.player);
        potion.setItem(stack);
        potion.shootFromRotation((Entity)this.player, this.player.getXRot(), this.player.getYRot(), 0.0f, 1.5f, 1.0f);
        this.player.level().addFreshEntity((Entity)potion);
        this.setCooldown(20);
    }
}

