/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.compat.jei;

import com.portingdeadmods.nautec.compat.jei.categories.AquaticCatalystChannelingRecipeCategory;
import com.portingdeadmods.nautec.compat.jei.categories.AugmentationRecipeCategory;
import com.portingdeadmods.nautec.compat.jei.categories.ItemEtchingRecipeCategory;
import com.portingdeadmods.nautec.compat.jei.categories.ItemTransformationRecipeCategory;
import com.portingdeadmods.nautec.compat.jei.categories.MixingRecipeCategory;
import com.portingdeadmods.nautec.content.recipes.AquaticCatalystChannelingRecipe;
import com.portingdeadmods.nautec.content.recipes.AugmentationRecipe;
import com.portingdeadmods.nautec.content.recipes.ItemEtchingRecipe;
import com.portingdeadmods.nautec.content.recipes.ItemTransformationRecipe;
import com.portingdeadmods.nautec.content.recipes.MixingRecipe;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTItems;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class NTJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemTransformationRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AquaticCatalystChannelingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemEtchingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MixingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AugmentationRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[0]);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List<ItemTransformationRecipe> transformationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ItemTransformationRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        List<AquaticCatalystChannelingRecipe> channelingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AquaticCatalystChannelingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        List<ItemEtchingRecipe> etchingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ItemEtchingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        List<MixingRecipe> mixingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MixingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        List<AugmentationRecipe> augmentationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AugmentationRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(AugmentationRecipeCategory.RECIPE_TYPE, augmentationRecipes);
        registration.addRecipes(ItemTransformationRecipeCategory.RECIPE_TYPE, transformationRecipes);
        registration.addRecipes(AquaticCatalystChannelingRecipeCategory.RECIPE_TYPE, channelingRecipes);
        registration.addRecipes(ItemEtchingRecipeCategory.RECIPE_TYPE, etchingRecipes);
        registration.addRecipes(MixingRecipeCategory.RECIPE_TYPE, mixingRecipes);
        for (AugmentationRecipe recipe : augmentationRecipes) {
            registration.addIngredientInfo((Object)recipe.augmentItem().getDefaultInstance(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)recipe.desc())});
        }
        registration.addIngredientInfo((Object)NTItems.PRISMARINE_CRYSTAL_SHARD.toStack(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.literal((String)"Prismarine Crystal Shards are pristine crystals, capable of channeling power like no other material. They can be obtained by breaking a prismarine crystal using an Aquarine Steel Pickaxe with its ability enabled.")});
        registration.addIngredientInfo(List.of(NTItems.BROKEN_WHISK.toStack(), NTItems.BURNT_COIL.toStack(), NTItems.ANCIENT_VALVE.toStack(), NTItems.RUSTY_GEAR.toStack()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.literal((String)"These ancient machine components can be found in chests and are dropped by underwater mobs")});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTBlocks.AQUATIC_CATALYST.get()), new RecipeType[]{AquaticCatalystChannelingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTItems.ETCHING_ACID_BUCKET.get()), new RecipeType[]{ItemEtchingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTBlocks.MIXER.get()), new RecipeType[]{MixingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NTBlocks.AUGMENTATION_STATION.get()), new RecipeType[]{AugmentationRecipeCategory.RECIPE_TYPE});
    }
}

