/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.renderer.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.nautec.content.blockentities.LongDistanceLaserBlockEntity;
import com.portingdeadmods.nautec.utils.LaserRendererHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class LongDistanceLaserBERenderer
implements BlockEntityRenderer<LongDistanceLaserBlockEntity> {
    public LongDistanceLaserBERenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(LongDistanceLaserBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockPos originPos = blockEntity.getBlockPos();
        Object2IntMap<Direction> laserDistances = blockEntity.getLaserDistances();
        for (Direction direction : blockEntity.getLaserOutputs()) {
            int laserDistance = laserDistances.getOrDefault((Object)direction, 0);
            BlockPos targetPos = originPos.relative(direction, laserDistance - 1);
            if (laserDistance == 0 || !blockEntity.shouldRender(direction)) continue;
            LaserRendererHelper.renderOuterBeam(blockEntity, originPos, targetPos, 0.0f, direction, poseStack, bufferSource, partialTick);
            poseStack.pushPose();
            poseStack.mulPose(direction.getRotation());
            poseStack.scale(0.25f, 1.0f, 0.25f);
            switch (direction) {
                case UP: {
                    poseStack.translate(1.5f, 0.0f, 1.5f);
                    break;
                }
                case DOWN: 
                case SOUTH: 
                case WEST: {
                    poseStack.translate(1.5f, 0.0f, -2.5f);
                    break;
                }
                case NORTH: 
                case EAST: {
                    poseStack.translate(-2.5f, 0.0f, -2.5f);
                }
            }
            LaserRendererHelper.renderInnerBeam(poseStack, bufferSource, partialTick, blockEntity.getLevel().getGameTime(), 0.0f, laserDistance, FastColor.ARGB32.color((int)202, (int)214, (int)224));
            poseStack.popPose();
        }
    }

    public boolean shouldRenderOffScreen(LongDistanceLaserBlockEntity blockEntity) {
        return true;
    }

    @NotNull
    public AABB getRenderBoundingBox(LongDistanceLaserBlockEntity blockEntity) {
        BlockPos blockPos = blockEntity.getBlockPos();
        AABB box = new AABB(blockPos);
        Object2IntMap<Direction> laserDistances = blockEntity.getLaserDistances();
        for (Direction direction : blockEntity.getLaserOutputs()) {
            int distance = laserDistances.getOrDefault((Object)direction, 0);
            BlockPos pos = blockPos.relative(direction, distance);
            BlockPos relative = blockPos.subtract((Vec3i)pos);
            box = box.expandTowards((double)(-relative.getX()), (double)(-relative.getY()), (double)(-relative.getZ()));
        }
        return box;
    }
}

