/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.renderer.augments.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.portingdeadmods.nautec.content.augments.GuardianEyeAugment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GuardianEyeRenderHelper {
    private static final ResourceLocation GUARDIAN_BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)GUARDIAN_BEAM_LOCATION);

    public static void render(Player entity, GuardianEyeAugment augment, float partialTicks, PoseStack poseStack, MultiBufferSource buffer) {
        Entity targetEntity = augment.getTargetEntity();
        Entity livingentity = targetEntity;
        if (livingentity != null) {
            float f = augment.getLaserScale(partialTicks);
            float f1 = augment.getClientLaserTime() + partialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = entity.getEyeHeight();
            poseStack.pushPose();
            poseStack.translate(0.0f, f3, 0.0f);
            Vec3 vec3 = GuardianEyeRenderHelper.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5, partialTicks);
            Vec3 vec31 = GuardianEyeRenderHelper.getPosition((Entity)entity, f3, partialTicks);
            Vec3 vec32 = vec3.subtract(vec31);
            float f4 = (float)(vec32.length() + 1.0);
            vec32 = vec32.normalize();
            float f5 = (float)Math.acos(vec32.y);
            float f6 = (float)Math.atan2(vec32.z, vec32.x);
            poseStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - f6) * 57.295776f));
            poseStack.mulPose(Axis.XP.rotationDegrees(f5 * 57.295776f));
            boolean i = true;
            float f7 = f1 * 0.05f * -1.5f;
            float f8 = f * f;
            int j = 64 + (int)(f8 * 191.0f);
            int k = 32 + (int)(f8 * 191.0f);
            int l = 128 - (int)(f8 * 64.0f);
            float f11 = Mth.cos((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = Mth.sin((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = Mth.cos((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = Mth.sin((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = Mth.cos((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = Mth.sin((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = Mth.cos((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = Mth.sin((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = Mth.cos((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = Mth.sin((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = Mth.cos((float)(f7 + 0.0f)) * 0.2f;
            float f22 = Mth.sin((float)(f7 + 0.0f)) * 0.2f;
            float f23 = Mth.cos((float)(f7 + 1.5707964f)) * 0.2f;
            float f24 = Mth.sin((float)(f7 + 1.5707964f)) * 0.2f;
            float f25 = Mth.cos((float)(f7 + 4.712389f)) * 0.2f;
            float f26 = Mth.sin((float)(f7 + 4.712389f)) * 0.2f;
            float f27 = 0.0f;
            float f28 = 0.4999f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            VertexConsumer vertexconsumer = buffer.getBuffer(BEAM_RENDER_TYPE);
            PoseStack.Pose posestack$pose = poseStack.last();
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f19, f4, f20, j, k, l, 0.4999f, f30);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f21, f4, f22, j, k, l, 0.0f, f30);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f23, f4, f24, j, k, l, 0.4999f, f30);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (entity.tickCount % 2 == 0) {
                f31 = 0.5f;
            }
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f17, f4, f18, j, k, l, 1.0f, f31);
            GuardianEyeRenderHelper.vertex(vertexconsumer, posestack$pose, f15, f4, f16, j, k, l, 0.5f, f31);
            poseStack.popPose();
        }
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int red, int green, int blue, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private static Vec3 getPosition(Entity livingEntity, double yOffset, float partialTick) {
        double d0 = Mth.lerp((double)partialTick, (double)livingEntity.xOld, (double)livingEntity.getX());
        double d1 = Mth.lerp((double)partialTick, (double)livingEntity.yOld, (double)livingEntity.getY()) + yOffset;
        double d2 = Mth.lerp((double)partialTick, (double)livingEntity.zOld, (double)livingEntity.getZ());
        return new Vec3(d0, d1, d2);
    }
}

