/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.renderer.augments;

import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.api.client.model.augments.AugmentModel;
import com.portingdeadmods.nautec.api.client.renderer.augments.AugmentRenderer;
import com.portingdeadmods.nautec.events.helper.AugmentLayerRenderer;
import com.portingdeadmods.nautec.events.helper.AugmentSlotsRenderer;
import java.util.function.Function;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;

public class SimpleAugmentRenderer<T extends Augment>
extends AugmentRenderer<T> {
    private final AugmentModel<T> model;
    private final Material material;
    private final boolean moveWithBody;

    public SimpleAugmentRenderer(Function<ModelPart, AugmentModel<T>> model, ModelLayerLocation layerLocation, Material material, boolean moveWithBody, AugmentRenderer.Context ctx) {
        super(ctx);
        this.material = material;
        this.model = model.apply(ctx.entityModelSet().bakeLayer(layerLocation));
        this.moveWithBody = moveWithBody;
    }

    @Override
    public void render(T augment, AugmentLayerRenderer superRenderer, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        ModelPart modelPart;
        poseStack.pushPose();
        AugmentSlot augmentSlot = ((Augment)augment).getAugmentSlot();
        if (augmentSlot != null && (modelPart = AugmentSlotsRenderer.modelPartBySlot(augmentSlot).getModelPart((PlayerModel<AbstractClientPlayer>)((PlayerModel)superRenderer.getParentModel()))) != null && this.moveWithBody) {
            modelPart.translateAndRotate(poseStack);
        }
        this.model.renderToBuffer(poseStack, this.material.buffer(bufferSource, arg_0 -> this.model.renderType(arg_0)), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

