/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.capabilities.power;

import com.portingdeadmods.nautec.Nautec;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Range;

public interface IPowerStorage {
    public int getPowerStored();

    public int getPowerCapacity();

    public @Range(from=0L, to=1L) float getPurity();

    public void setPowerStored(int var1);

    public void setPowerCapacity(int var1);

    public void setPurity(float var1);

    public int getMaxInput();

    public int getMaxOutput();

    default public void onEnergyChanged() {
    }

    default public boolean canFillPower() {
        return this.getMaxInput() > 0;
    }

    default public boolean canDrainPower() {
        return this.getMaxOutput() > 0;
    }

    default public int tryDrainPower(int value, boolean simulate) {
        if (!this.canDrainPower() || value <= 0) {
            return 0;
        }
        int powerExtracted = Math.min(this.getPowerStored(), Math.min(this.getMaxOutput(), value));
        if (!simulate) {
            Nautec.LOGGER.debug("Draining Power");
            this.setPowerStored(this.getPowerStored() - powerExtracted);
        }
        return powerExtracted;
    }

    default public int tryFillPower(int value, boolean simulate) {
        if (!this.canFillPower() || value <= 0) {
            return 0;
        }
        int powerReceived = Mth.clamp((int)(this.getPowerCapacity() - this.getPowerStored()), (int)0, (int)Math.min(this.getMaxInput(), value));
        if (!simulate) {
            this.setPowerStored(this.getPowerStored() + powerReceived);
        }
        return powerReceived;
    }
}

