/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.blockentities;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.content.recipes.ItemTransformationRecipe;
import com.portingdeadmods.nautec.content.recipes.inputs.ItemTransformationRecipeInput;
import com.portingdeadmods.nautec.utils.ParticleUtils;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class LaserBlockEntity
extends ContainerBlockEntity {
    protected final Object2IntMap<Direction> laserDistances = new Object2IntOpenHashMap();
    private final Object2ObjectMap<Direction, Object2IntMap<ItemEntity>> activeTransformations = new Object2ObjectArrayMap();
    private int powerToTransfer;
    protected int power;
    private final Object2IntMap<Direction> powerPerSide = new Object2IntArrayMap();
    private final Object2FloatMap<Direction> purityPerSide = new Object2FloatArrayMap();
    private float newPurity;
    protected float purity = 0.0f;
    private float clientLaserTime;

    public LaserBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public abstract ObjectSet<Direction> getLaserInputs();

    public abstract ObjectSet<Direction> getLaserOutputs();

    public boolean shouldRender(Direction direction) {
        return this.getLaserOutputs().contains((Object)direction) && (this.power > 0 || this.powerToTransfer > 0);
    }

    public Object2IntMap<Direction> getLaserDistances() {
        return this.laserDistances;
    }

    public int getMaxLaserDistance() {
        return NTConfig.laserDistance;
    }

    protected int checkConnectionsInterval() {
        return 10;
    }

    public void setPowerPerSide(Direction direction, int power) {
        this.powerPerSide.put((Object)direction, power);
    }

    public int getPower() {
        return this.power;
    }

    public void transmitPower(int amount) {
        this.powerToTransfer = amount;
    }

    public void receivePower(int amount, Direction direction, BlockPos originPos) {
        this.setPowerPerSide(direction, amount);
    }

    public void setPurityPerSide(Direction direction, float purity) {
        this.purityPerSide.put((Object)direction, purity);
    }

    public float getPurity() {
        return this.purity;
    }

    public void setPurity(float amount) {
        this.newPurity = amount;
    }

    public void receiveNewPurity(float amount, Direction direction, BlockPos originPos) {
        this.setPurityPerSide(direction, amount);
    }

    @Override
    public void commonTick() {
        Direction direction2;
        super.commonTick();
        if (this.level.isClientSide()) {
            this.clientLaserTime = this.clientLaserTime < (float)this.getLaserAnimTimeDuration() ? (this.clientLaserTime += 0.5f) : 0.0f;
        }
        if (this.level.getGameTime() % (long)this.checkConnectionsInterval() == 0L) {
            this.checkConnections();
        }
        for (Direction direction2 : this.getLaserOutputs()) {
            int distance = this.laserDistances.getInt((Object)direction2);
            if (distance <= 0) continue;
            AABB box = this.createLaserBeamAABB(direction2, distance);
            this.damageLivingEntities(box);
            this.processItemCrafting(box, direction2);
            BlockPos targetPos = this.worldPosition.relative(direction2, distance);
            BlockEntity blockEntity = this.level.getBlockEntity(targetPos);
            if (!(blockEntity instanceof LaserBlockEntity)) continue;
            LaserBlockEntity laserBE = (LaserBlockEntity)blockEntity;
            laserBE.receivePower(this.powerToTransfer, direction2, this.worldPosition);
            laserBE.receiveNewPurity(this.purity, direction2, this.worldPosition);
        }
        int power = 0;
        direction2 = this.powerPerSide.values().iterator();
        while (direction2.hasNext()) {
            int pps = (Integer)direction2.next();
            power += pps;
        }
        this.power = power;
        float purity = 0.0f;
        FloatIterator pps = this.purityPerSide.values().iterator();
        while (pps.hasNext()) {
            float pps2 = ((Float)pps.next()).floatValue();
            purity += pps2;
        }
        int size = this.purityPerSide.size();
        this.purity = this.newPurity + purity / (float)(size > 0 ? size : 1);
        this.powerPerSide.clear();
    }

    private void damageLivingEntities(AABB box) {
        List livingEntities = this.level.getEntitiesOfClass(LivingEntity.class, box);
        for (LivingEntity livingEntity : livingEntities) {
            livingEntity.hurt(this.level.damageSources().inFire(), 3.0f);
        }
    }

    private Optional<ItemTransformationRecipe> getCurrentRecipe(ItemStack itemStack) {
        ItemTransformationRecipeInput recipeInput = new ItemTransformationRecipeInput(itemStack, this.getPurity());
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ItemTransformationRecipe.Type.INSTANCE, (RecipeInput)recipeInput, this.level).map(RecipeHolder::value);
    }

    private void processItemCrafting(AABB box, Direction direction) {
        List itemEntities = this.level.getEntitiesOfClass(ItemEntity.class, box);
        for (ItemEntity itemEntity : itemEntities) {
            Optional<ItemTransformationRecipe> optionalRecipe;
            if (this.activeTransformations.containsKey((Object)direction) && ((Object2IntMap)this.activeTransformations.get((Object)direction)).containsKey((Object)itemEntity) || !(optionalRecipe = this.getCurrentRecipe(itemEntity.getItem())).isPresent()) continue;
            if (!this.activeTransformations.containsKey((Object)direction)) {
                this.activeTransformations.put((Object)direction, (Object)new Object2IntArrayMap());
            }
            ((Object2IntMap)this.activeTransformations.get((Object)direction)).put((Object)itemEntity, 0);
        }
        if (this.activeTransformations.containsKey((Object)direction) && !((Object2IntMap)this.activeTransformations.get((Object)direction)).isEmpty()) {
            Object2IntMap activeTransformation = (Object2IntMap)this.activeTransformations.get((Object)direction);
            ObjectIterator iterator = activeTransformation.object2IntEntrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ItemEntity cookingItem = (ItemEntity)entry.getKey();
                int cookTime = (Integer)entry.getValue();
                if (!cookingItem.isAlive() || !box.contains(cookingItem.position())) {
                    iterator.remove();
                    continue;
                }
                Optional<ItemTransformationRecipe> optionalRecipe = this.getCurrentRecipe(cookingItem.getItem());
                if (!optionalRecipe.isPresent()) continue;
                if (cookTime >= optionalRecipe.get().duration()) {
                    ItemStack resultStack = optionalRecipe.get().getResultItem(null).copy();
                    resultStack.setCount(cookingItem.getItem().getCount());
                    ItemEntity resultEntity = new ItemEntity(this.level, cookingItem.getX(), cookingItem.getY(), cookingItem.getZ(), resultStack);
                    this.level.addFreshEntity((Entity)resultEntity);
                    cookingItem.discard();
                    iterator.remove();
                    continue;
                }
                activeTransformation.put((Object)cookingItem, cookTime + 1);
                ParticleUtils.spawnParticlesAroundItem(cookingItem, this.level, (ParticleOptions)ParticleTypes.END_ROD);
            }
        }
    }

    @NotNull
    private AABB createLaserBeamAABB(Direction direction, int distance) {
        BlockPos pos = this.worldPosition.relative(direction, distance);
        Vec3 start = this.worldPosition.relative(direction).getCenter();
        double v = 0.3;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            start = start.subtract(v, 0.0, v);
        } else if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            start = start.subtract(v, v, 0.0);
        } else if (direction == Direction.EAST || direction == Direction.WEST) {
            start = start.subtract(0.0, v, v);
        }
        Vec3 end = pos.getCenter().add(0.1, 0.0, 0.1);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            Vec3 endPos = pos.below().getCenter();
            end = endPos.add(v, 0.0, v);
        } else if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            end = end.add(v, v, 0.0);
        } else if (direction == Direction.EAST || direction == Direction.WEST) {
            end = end.add(0.0, v, v);
        }
        return new AABB(start, end);
    }

    protected void checkConnections() {
        block0: for (Direction direction : this.getLaserOutputs()) {
            int maxLaserDistance = this.getMaxLaserDistance();
            for (int i = 1; i < maxLaserDistance; ++i) {
                LaserBlockEntity laserBlockEntity;
                BlockPos pos = this.worldPosition.relative(direction, i);
                BlockState state = this.level.getBlockState(pos);
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (blockEntity instanceof LaserBlockEntity && (laserBlockEntity = (LaserBlockEntity)blockEntity).getLaserInputs().contains((Object)direction.getOpposite())) {
                    this.laserDistances.put((Object)direction, i);
                    continue block0;
                }
                if (state.canBeReplaced() && i != maxLaserDistance - 1) continue;
                this.laserDistances.put((Object)direction, 0);
                continue block0;
            }
        }
    }

    public int getLaserAnimTimeDuration() {
        return 80;
    }

    public float getClientLaserTime() {
        return this.clientLaserTime;
    }

    public float getLaserScale(float partialTick) {
        return (this.clientLaserTime + partialTick) / (float)this.getLaserAnimTimeDuration();
    }
}

