/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.augments;

import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import java.util.List;

public class AugmentType<T extends Augment> {
    private final AugmentConstructor<T> augmentConstructor;
    private final List<AugmentSlot> augmentSlots;

    public static <T extends Augment> AugmentType<T> of(AugmentConstructor<T> constructor, AugmentSlot ... compatibleSlots) {
        return new AugmentType<T>(constructor, compatibleSlots);
    }

    private AugmentType(AugmentConstructor<T> augmentConstructor, AugmentSlot ... compatibleSlots) {
        this.augmentConstructor = augmentConstructor;
        if (compatibleSlots.length == 0) {
            Nautec.LOGGER.warn("The augment: {} does not have any compatible slots, meaning it cannot be applied to the player.", (Object)NTRegistries.AUGMENT_TYPE.getKey((Object)this));
        }
        this.augmentSlots = List.of(compatibleSlots);
    }

    public T create(AugmentSlot augmentSlot) {
        return this.augmentConstructor.create(augmentSlot);
    }

    public List<AugmentSlot> getAugmentSlots() {
        return this.augmentSlots;
    }

    public String toString() {
        return NTRegistries.AUGMENT_TYPE.getKey((Object)this).toString();
    }

    @FunctionalInterface
    public static interface AugmentConstructor<T extends Augment> {
        public T create(AugmentSlot var1);
    }
}

