/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.lib;

import com.blakebr0.mysticalagradditions.MysticalAgradditions;
import com.blakebr0.mysticalagradditions.init.ModBlocks;
import com.blakebr0.mysticalagradditions.lib.ModCropTiers;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import java.util.Arrays;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;

public final class ModCrops {
    private static final boolean DEBUG = !FMLEnvironment.production;
    public static final Crop NETHER_STAR = new Crop(MysticalAgradditions.resource("nether_star"), ModCropTiers.SIX, CropType.RESOURCE, LazyIngredient.item((String)"minecraft:nether_star"));
    public static final Crop DRAGON_EGG = new Crop(MysticalAgradditions.resource("dragon_egg"), ModCropTiers.SIX, CropType.RESOURCE, LazyIngredient.item((String)"mysticalagradditions:dragon_scale"));
    public static final Crop GAIA_SPIRIT = new Crop(MysticalAgradditions.resource("gaia_spirit"), ModCropTiers.SIX, CropType.RESOURCE, LazyIngredient.item((String)"botania:life_essence"));
    public static final Crop AWAKENED_DRACONIUM = new Crop(MysticalAgradditions.resource("awakened_draconium"), ModCropTiers.SIX, CropType.RESOURCE, LazyIngredient.tag((String)"forge:ingots/draconium_awakened"));
    public static final Crop NEUTRONIUM = new Crop(MysticalAgradditions.resource("neutronium"), ModCropTiers.SIX, CropType.RESOURCE, LazyIngredient.item((String)"avaritia:neutronium_ingot"));
    public static final Crop NITRO_CRYSTAL = new Crop(MysticalAgradditions.resource("nitro_crystal"), ModCropTiers.SIX, CropType.RESOURCE, LazyIngredient.item((String)"powah:crystal_nitro"));

    public static void onRegisterCrops(ICropRegistry registry) {
        registry.register(NETHER_STAR);
        registry.register(DRAGON_EGG);
        registry.register(ModCrops.withRequiredMods(GAIA_SPIRIT, "botania"));
        registry.register(ModCrops.withRequiredMods(AWAKENED_DRACONIUM, "draconicevolution"));
        registry.register(ModCrops.withRequiredMods(NEUTRONIUM, "avaritia"));
        registry.register(ModCrops.withRequiredMods(NITRO_CRYSTAL, "powah"));
    }

    public static void onPostRegisterCrops(ICropRegistry registry) {
        NETHER_STAR.setCruxBlock(ModBlocks.NETHER_STAR_CRUX);
        DRAGON_EGG.setCruxBlock(ModBlocks.DRAGON_EGG_CRUX);
        GAIA_SPIRIT.setCruxBlock(ModBlocks.GAIA_SPIRIT_CRUX);
        AWAKENED_DRACONIUM.setCruxBlock(ModBlocks.AWAKENED_DRACONIUM_CRUX);
        NEUTRONIUM.setCruxBlock(ModBlocks.NEUTRONIUM_CRUX);
        NITRO_CRYSTAL.setCruxBlock(ModBlocks.NITRO_CRYSTAL_CRUX);
    }

    private static Crop withRequiredMods(Crop crop, String ... mods) {
        if (DEBUG) {
            return crop;
        }
        boolean enabled = Arrays.stream(mods).anyMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
        return crop.setEnabled(enabled);
    }
}

