/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.neoforge;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.lucko.spark.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.neoforged.fml.ModList;

public abstract class NeoForgeWorldInfoProvider
implements WorldInfoProvider {
    protected abstract PackRepository getPackRepository();

    @Override
    public Collection<WorldInfoProvider.DataPackInfo> pollDataPacks() {
        return this.getPackRepository().getSelectedPacks().stream().map(pack -> new WorldInfoProvider.DataPackInfo(pack.getId(), pack.getDescription().getString(), NeoForgeWorldInfoProvider.resourcePackSource(pack.getPackSource()))).collect(Collectors.toList());
    }

    private static String resourcePackSource(PackSource source) {
        if (source == PackSource.DEFAULT) {
            return "none";
        }
        if (source == PackSource.BUILT_IN) {
            return "builtin";
        }
        if (source == PackSource.WORLD) {
            return "world";
        }
        if (source == PackSource.SERVER) {
            return "server";
        }
        return "unknown";
    }

    private static final class MoonriseMethods {
        private static Method getEntityCount;

        private MoonriseMethods() {
        }

        private static Method getEntityCountMethod(LevelEntityGetter<Entity> getter) {
            if (getEntityCount == null) {
                try {
                    getEntityCount = getter.getClass().getMethod("getEntityCount", new Class[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Cannot find Moonrise getEntityCount method", e);
                }
            }
            return getEntityCount;
        }

        private static int getEntityCount(LevelEntityGetter<Entity> getter) {
            try {
                return (Integer)MoonriseMethods.getEntityCountMethod(getter).invoke(getter, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to invoke Moonrise getEntityCount method", e);
            }
        }
    }

    public static final class ForgeChunkInfo
    extends AbstractChunkInfo<EntityType<?>> {
        private final CountMap<EntityType<?>> entityCounts = new CountMap.Simple(new HashMap());

        ForgeChunkInfo(long chunkPos) {
            super(ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos));
        }

        @Override
        public CountMap<EntityType<?>> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(EntityType<?> type) {
            return EntityType.getKey(type).toString();
        }
    }

    public static final class Client
    extends NeoForgeWorldInfoProvider {
        private final Minecraft client;

        public Client(Minecraft client) {
            this.client = client;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            int entities;
            ClientLevel level = this.client.level;
            if (level == null) {
                return null;
            }
            if (ModList.get().isLoaded("moonrise")) {
                entities = MoonriseMethods.getEntityCount((LevelEntityGetter<Entity>)level.getEntities());
            } else {
                TransientEntitySectionManager entityManager = level.entityStorage;
                EntityLookup entityIndex = entityManager.entityStorage;
                entities = entityIndex.count();
            }
            int chunks = level.getChunkSource().getLoadedChunksCount();
            return new WorldInfoProvider.CountsResult(-1, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<ForgeChunkInfo> pollChunks() {
            ClientLevel level = this.client.level;
            if (level == null) {
                return null;
            }
            WorldInfoProvider.ChunksResult<ForgeChunkInfo> data = new WorldInfoProvider.ChunksResult<ForgeChunkInfo>();
            Long2ObjectOpenHashMap levelInfos = new Long2ObjectOpenHashMap();
            for (Entity entity : level.getEntities().getAll()) {
                ForgeChunkInfo info = (ForgeChunkInfo)levelInfos.computeIfAbsent(entity.chunkPosition().toLong(), ForgeChunkInfo::new);
                info.entityCounts.increment(entity.getType());
            }
            data.put(level.dimension().location().getPath(), List.copyOf(levelInfos.values()));
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            ClientLevel level = this.client.level;
            if (level == null) {
                return null;
            }
            final WorldInfoProvider.GameRulesResult data = new WorldInfoProvider.GameRulesResult();
            final String levelName = level.dimension().location().getPath();
            final GameRules levelRules = level.getGameRules();
            GameRules.visitGameRuleTypes((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                    String defaultValue = type.createRule().serialize();
                    data.putDefault(key.getId(), defaultValue);
                    String value = levelRules.getRule(key).serialize();
                    data.put(key.getId(), levelName, value);
                }
            });
            return data;
        }

        @Override
        protected PackRepository getPackRepository() {
            return this.client.getResourcePackRepository();
        }
    }

    public static final class Server
    extends NeoForgeWorldInfoProvider {
        private final MinecraftServer server;

        public Server(MinecraftServer server) {
            this.server = server;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            int players = this.server.getPlayerCount();
            int entities = 0;
            int chunks = 0;
            for (ServerLevel level : this.server.getAllLevels()) {
                if (ModList.get().isLoaded("moonrise")) {
                    entities += MoonriseMethods.getEntityCount((LevelEntityGetter<Entity>)level.getEntities());
                } else {
                    PersistentEntitySectionManager entityManager = level.entityManager;
                    EntityLookup entityIndex = entityManager.visibleEntityStorage;
                    entities += entityIndex.count();
                }
                chunks += level.getChunkSource().getLoadedChunksCount();
            }
            return new WorldInfoProvider.CountsResult(players, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<ForgeChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<ForgeChunkInfo> data = new WorldInfoProvider.ChunksResult<ForgeChunkInfo>();
            for (ServerLevel level : this.server.getAllLevels()) {
                Long2ObjectOpenHashMap levelInfos = new Long2ObjectOpenHashMap();
                for (Entity entity : level.getEntities().getAll()) {
                    ForgeChunkInfo info = (ForgeChunkInfo)levelInfos.computeIfAbsent(entity.chunkPosition().toLong(), ForgeChunkInfo::new);
                    info.entityCounts.increment(entity.getType());
                }
                data.put(level.dimension().location().getPath(), List.copyOf(levelInfos.values()));
            }
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            final WorldInfoProvider.GameRulesResult data = new WorldInfoProvider.GameRulesResult();
            final Iterable levels = this.server.getAllLevels();
            GameRules.visitGameRuleTypes((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                    String defaultValue = type.createRule().serialize();
                    data.putDefault(key.getId(), defaultValue);
                    for (ServerLevel level : levels) {
                        String levelName = level.dimension().location().getPath();
                        String value = level.getGameRules().getRule(key).serialize();
                        data.put(key.getId(), levelName, value);
                    }
                }
            });
            return data;
        }

        @Override
        protected PackRepository getPackRepository() {
            return this.server.getPackRepository();
        }
    }
}

