/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.canyon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.math.LongPair;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.canyon.CanyonPiece;
import org.jetbrains.annotations.NotNull;

public class CanyonStructure
extends Structure {
    public static final MapCodec<CanyonStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CanyonStructure.settingsCodec((RecordCodecBuilder.Instance)builder)).apply((Applicative)builder, CanyonStructure::new));
    private static final BlockPos MAX = new BlockPos(59999968, 0, 59999968);
    private static final BlockPos MIN = new BlockPos(-59999968, 0, -59999968);

    public CanyonStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    @NotNull
    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        int plateauRadius = 100;
        return CanyonStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, piecesBuilder -> {
            BlockPos worldPosition = chunkPos.getMiddleBlockPosition(0);
            BoundingBox area = new BoundingBox(worldPosition.getX() - 256, 0, worldPosition.getZ() - 256, worldPosition.getX() + 256, 0, worldPosition.getZ() + 256);
            LongArrayList randomPositions = CanyonStructure.getRandomPositions(context.seed(), CanyonStructure.worldToCanyonQuadrant(plateauRadius) + 1, worldPosition);
            LongLinkedOpenHashSet riverPositions = CanyonStructure.getRiverPositions(context.seed(), randomPositions, area);
            LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
            CanyonStructure.createArenaFloor(context, piecesBuilder, plateauRadius, worldPosition, 100, levelHeightAccessor, (LongCollection)riverPositions);
        });
    }

    @NotNull
    public static LongLinkedOpenHashSet getRiverPositions(long worldSeed, LongArrayList randomPositions, BoundingBox area) {
        LongLinkedOpenHashSet riverPositions = new LongLinkedOpenHashSet();
        long[] longArray = randomPositions.toLongArray();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (long randomPosition : longArray) {
            mutableBlockPos.set(ChunkPos.getX((long)randomPosition), 0, ChunkPos.getZ((long)randomPosition));
            long firstClosest = CanyonStructure.findClosest(longArray, (BlockPos)mutableBlockPos);
            long secondClosest = CanyonStructure.find2ndClosest(longArray, (BlockPos)mutableBlockPos);
            long canyonPos = ChunkPos.asLong((int)CanyonStructure.worldToCanyonQuadrant(mutableBlockPos.getX()), (int)CanyonStructure.worldToCanyonQuadrant(mutableBlockPos.getZ()));
            BlockPos firstClosestPos = new BlockPos(ChunkPos.getX((long)firstClosest), 0, ChunkPos.getZ((long)firstClosest));
            BlockPos secondClosestPos = new BlockPos(ChunkPos.getX((long)secondClosest), 0, ChunkPos.getZ((long)secondClosest));
            List<BlockPos> positions = List.of(mutableBlockPos, firstClosestPos);
            List<BlockPos> secondPositions = List.of(mutableBlockPos, secondClosestPos);
            riverPositions.addAll((LongCollection)CanyonStructure.getPositions(CanyonStructure.getNearest(MIN, positions), CanyonStructure.getNearest(MAX, positions), area, new WorldgenRandom((RandomSource)new XoroshiroRandomSource(worldSeed + canyonPos)), 10));
            riverPositions.addAll((LongCollection)CanyonStructure.getPositions(CanyonStructure.getNearest(MIN, secondPositions), CanyonStructure.getNearest(MAX, secondPositions), area, new WorldgenRandom((RandomSource)new XoroshiroRandomSource(worldSeed + canyonPos)), 10));
        }
        return riverPositions;
    }

    private static BlockPos getNearest(BlockPos anchor, List<BlockPos> positions) {
        BlockPos lowest = positions.getFirst();
        double closestDist = anchor.distSqr((Vec3i)lowest);
        for (int i = 1; i < positions.size(); ++i) {
            BlockPos blockPos = positions.get(i);
            double distance = blockPos.distSqr((Vec3i)anchor);
            if (!(distance < closestDist)) continue;
            lowest = blockPos;
            closestDist = distance;
        }
        return lowest;
    }

    @NotNull
    public static LongArrayList getRandomPositions(long worldSeed, int canyonRange, BlockPos worldPosition) {
        LongArrayList randomPositions = new LongArrayList();
        for (int canyonOffsetX = -canyonRange; canyonOffsetX <= canyonRange; ++canyonOffsetX) {
            for (int canyonOffsetZ = -canyonRange; canyonOffsetZ <= canyonRange; ++canyonOffsetZ) {
                int canyonX = CanyonStructure.worldToCanyonQuadrant(worldPosition.getX()) + canyonOffsetX;
                int canyonZ = CanyonStructure.worldToCanyonQuadrant(worldPosition.getZ()) + canyonOffsetZ;
                long canyonPos = ChunkPos.asLong((int)canyonX, (int)canyonZ);
                WorldgenRandom canyonQuadrantRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(worldSeed + canyonPos));
                int canyonPointCount = canyonQuadrantRandom.nextIntBetweenInclusive(2, 6);
                int size = CanyonStructure.canyonQuadrantToWorld(1);
                int worldX = CanyonStructure.canyonQuadrantToWorld(canyonX);
                int worldZ = CanyonStructure.canyonQuadrantToWorld(canyonZ);
                for (int i = 0; i <= canyonPointCount; ++i) {
                    long point = ChunkPos.asLong((int)(worldX + canyonQuadrantRandom.nextIntBetweenInclusive(0, size)), (int)(worldZ + canyonQuadrantRandom.nextIntBetweenInclusive(0, size)));
                    randomPositions.add(point);
                }
            }
        }
        return randomPositions;
    }

    public static int worldToCanyonQuadrant(int coord) {
        return coord >> 7;
    }

    public static int canyonQuadrantToWorld(int coord) {
        return coord << 7;
    }

    public static LongArrayList getPositions(BlockPos startPos, BlockPos endPos, BoundingBox area, WorldgenRandom random, int step) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)startPos);
        double chance = 0.01 * (double)step;
        LongArrayList positions = new LongArrayList();
        int cooldown = 0;
        while (!endPos.closerThan((Vec3i)mutableBlockPos, (double)step)) {
            double angleBetween = CanyonStructure.angleBetween((Vec3i)mutableBlockPos, (Vec3i)endPos);
            if (random.nextDouble() < chance && cooldown >= 5) {
                angleBetween = Mth.randomBetween((RandomSource)random, (float)-1.5707964f, (float)1.5707964f);
                chance = 0.01 * (double)step;
                cooldown = 0;
            } else {
                chance *= 1.5;
            }
            ++cooldown;
            double xMove = Math.sin(angleBetween) * (double)step;
            double zMove = Math.cos(angleBetween) * (double)step;
            mutableBlockPos.move((int)Math.round(xMove), 0, (int)Math.round(zMove));
            if (!area.isInside((Vec3i)mutableBlockPos)) continue;
            positions.add(ChunkPos.asLong((int)mutableBlockPos.getX(), (int)mutableBlockPos.getZ()));
        }
        return positions;
    }

    public static long findClosest(long[] points, BlockPos pos) {
        long closest = points[0];
        pos = pos.atY(0);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (long point : points) {
            mutableBlockPos.set(ChunkPos.getX((long)closest), 0, ChunkPos.getZ((long)closest));
            double distance = pos.distSqr((Vec3i)mutableBlockPos);
            mutableBlockPos.set(ChunkPos.getX((long)point), 0, ChunkPos.getZ((long)point));
            if (!pos.equals((Object)mutableBlockPos) && !pos.closerThan((Vec3i)mutableBlockPos, Math.sqrt(distance))) continue;
            closest = point;
        }
        return closest;
    }

    public static long find2ndClosest(long[] points, BlockPos pos) {
        Long closest = null;
        Long secondClosest = null;
        pos = pos.atY(0);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (long point : points) {
            if (closest != null) {
                mutableBlockPos.set(ChunkPos.getX((long)closest), 0, ChunkPos.getZ((long)closest));
                double distance = pos.distSqr((Vec3i)mutableBlockPos);
                mutableBlockPos.set(ChunkPos.getX((long)point), 0, ChunkPos.getZ((long)point));
                if (!pos.equals((Object)mutableBlockPos) && !pos.closerThan((Vec3i)mutableBlockPos, Math.sqrt(distance))) continue;
                secondClosest = closest;
                closest = point;
                continue;
            }
            closest = point;
            secondClosest = point;
        }
        return secondClosest;
    }

    public static LongPair find2Closest(long[] points, BlockPos pos) {
        Long closest = null;
        Long secondClosest = null;
        pos = pos.atY(0);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        double closestDistance = Double.MAX_VALUE;
        double secondClosestDistance = Double.MAX_VALUE;
        for (long point : points) {
            mutableBlockPos.set(ChunkPos.getX((long)point), 0, ChunkPos.getZ((long)point));
            double distance = pos.distSqr((Vec3i)mutableBlockPos);
            if (distance < closestDistance) {
                secondClosest = closest;
                secondClosestDistance = closestDistance;
                closest = point;
                closestDistance = distance;
                continue;
            }
            if (!(distance < secondClosestDistance)) continue;
            secondClosest = point;
            secondClosestDistance = distance;
        }
        return new LongPair(closest != null ? closest : 0L, secondClosest != null ? secondClosest : 0L);
    }

    public static IntIntPair find2ClosestIndexes(long[] points, BlockPos pos) {
        int closest = -1;
        int secondClosest = -1;
        pos = pos.atY(0);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < points.length; ++i) {
            long point = points[i];
            mutableBlockPos.set(ChunkPos.getX((long)closest), 0, ChunkPos.getZ((long)closest));
            double distance = pos.distSqr((Vec3i)mutableBlockPos);
            mutableBlockPos.set(ChunkPos.getX((long)point), 0, ChunkPos.getZ((long)point));
            if (!pos.equals((Object)mutableBlockPos) && !pos.closerThan((Vec3i)mutableBlockPos, Math.sqrt(distance))) continue;
            secondClosest = closest;
            closest = i;
        }
        return new IntIntImmutablePair(closest, secondClosest);
    }

    public static double angleBetween(Vec3i p1, Vec3i p2) {
        double deltaX = p2.getX() - p1.getX();
        double deltaY = p2.getZ() - p1.getZ();
        return Math.atan2(deltaX, deltaY);
    }

    private static void createArenaFloor(Structure.GenerationContext context, StructurePiecesBuilder piecesBuilder, int arenaFloorRadius, BlockPos arenaOrigin, int topY, LevelHeightAccessor levelHeightAccessor, LongCollection positions) {
        int range = SectionPos.blockToSectionCoord((int)arenaFloorRadius) + 1;
        for (int chunkX = -range; chunkX <= range; ++chunkX) {
            for (int chunkZ = -range; chunkZ <= range; ++chunkZ) {
                BlockPos chunkWorldPos = new BlockPos(SectionPos.sectionToBlockCoord((int)(context.chunkPos().x + chunkX)), arenaOrigin.getY(), SectionPos.sectionToBlockCoord((int)(context.chunkPos().z + chunkZ)));
                BoundingBox boundingBox = new BoundingBox(chunkWorldPos.getX(), levelHeightAccessor.getMinBuildHeight(), chunkWorldPos.getZ(), chunkWorldPos.getX() + 15, levelHeightAccessor.getMaxBuildHeight(), chunkWorldPos.getZ() + 15);
                piecesBuilder.addPiece((StructurePiece)new CanyonPiece(arenaOrigin, arenaFloorRadius, topY, positions, boundingBox));
            }
        }
    }

    @NotNull
    public StructureType<?> type() {
        return BWGStructureTypes.CANYON.get();
    }
}

