/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.canyon;

import corgitaco.corgilib.math.LongPair;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.tags.BWGBiomeTags;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.canyon.CanyonStructure;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class CanyonPiece
extends StructurePiece {
    private final BlockPos origin;
    private final int radius;
    private final int topY;
    private final long[] packedCanyonPositions;

    protected CanyonPiece(BlockPos origin, int radius, int topY, LongCollection packedCanyonPositions, BoundingBox boundingBox) {
        super(BWGStructurePieceTypes.CANYON_PIECE.get(), 0, boundingBox);
        this.origin = origin;
        this.radius = radius;
        this.topY = topY;
        this.packedCanyonPositions = packedCanyonPositions.toLongArray();
    }

    public CanyonPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BWGStructurePieceTypes.CANYON_PIECE.get(), tag);
        this.origin = (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"origin").orElseThrow();
        this.radius = tag.getInt("radius");
        this.topY = tag.getInt("topY");
        this.packedCanyonPositions = tag.getLongArray("canyon_positions");
    }

    protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext context, CompoundTag tag) {
        tag.put("origin", NbtUtils.writeBlockPos((BlockPos)this.origin));
        tag.putInt("radius", this.radius);
        tag.putInt("topY", this.topY);
        tag.putLongArray("canyon_positions", this.packedCanyonPositions);
    }

    public void postProcess(@NotNull WorldGenLevel worldGenLevel, @NotNull StructureManager structureManager, @NotNull ChunkGenerator generator, @NotNull RandomSource unused, @NotNull BoundingBox box, @NotNull ChunkPos chunkPos, @NotNull BlockPos pos) {
        CanyonPiece.generate(worldGenLevel, generator, chunkPos, this.packedCanyonPositions);
    }

    public static void generate(WorldGenLevel worldGenLevel, ChunkGenerator generator, ChunkPos chunkPos, long[] packedCanyonPositions) {
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(worldGenLevel.getSeed()));
        WorldgenRandom originRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(worldGenLevel.getSeed()));
        ChunkAccess chunk = worldGenLevel.getChunk(chunkPos.x, chunkPos.z);
        ImprovedNoise noise = new ImprovedNoise((RandomSource)worldgenRandom);
        int distance = Mth.square((int)worldgenRandom.nextIntBetweenInclusive(15, 20));
        int biomeSampleDistance = 24;
        BlockState[] bandStates = new BlockState[]{Blocks.TERRACOTTA.defaultBlockState(), Blocks.WHITE_TERRACOTTA.defaultBlockState(), Blocks.LIGHT_GRAY_TERRACOTTA.defaultBlockState(), Blocks.WHITE_TERRACOTTA.defaultBlockState(), Blocks.ORANGE_TERRACOTTA.defaultBlockState()};
        BlockState[] bands = new BlockState[25];
        int i = 0;
        while (i < bands.length) {
            BlockState selectedState = bandStates[worldgenRandom.nextInt(bandStates.length)];
            int fillerSize = worldgenRandom.nextInt(1, 5);
            for (int filler = 0; filler < fillerSize && i < bands.length; ++i, ++filler) {
                bands[i] = selectedState;
            }
        }
        BlendingFunction[] functions = new BlendingFunction[]{BlendingFunction.EaseInOutCirc.INSTANCE, BlendingFunction.EaseInCirc.INSTANCE, BlendingFunction.EaseOutCubic.INSTANCE, BlendingFunction.EaseOutQuint.INSTANCE};
        double[] anchors = new double[256];
        double[] biomeAnchors = new double[256];
        Arrays.fill(biomeAnchors, -1.0);
        int[] heightmap = new int[256];
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockX = chunkPos.getBlockX(x);
                int blockZ = chunkPos.getBlockZ(z);
                mutable.set(blockX, 0, blockZ);
                LongPair nearest2Points = CanyonStructure.find2Closest(packedCanyonPositions, (BlockPos)mutable);
                int index = x + z * 16;
                anchors[index] = CanyonPiece.getDistanceToClosestPoint(nearest2Points.getVal1(), nearest2Points.getVal2(), blockX, blockZ);
                biomeAnchors[index] = CanyonPiece.nearestBiome(blockX, blockZ, biomeSampleDistance, worldGenLevel, biomeHolder -> biomeHolder.is(BWGBiomeTags.CANYON) || biomeHolder.is(BiomeTags.IS_RIVER));
                heightmap[index] = worldGenLevel.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, mutable.getX(), mutable.getZ()) - 1;
            }
        }
        int[] mins = new int[256];
        int[] maxes = new int[256];
        int[] offsets = new int[256];
        int[] distances = new int[256];
        Arrays.fill(mins, generator.getSeaLevel() - 2);
        Arrays.fill(maxes, generator.getSeaLevel() - 2 + worldgenRandom.nextIntBetweenInclusive(10, 20));
        Arrays.fill(offsets, distance / 2);
        for (int layer = 0; layer <= 10; ++layer) {
            double layerDelta = (double)layer / 10.0;
            ImprovedNoise layerNoise = new ImprovedNoise((RandomSource)new WorldgenRandom((RandomSource)new XoroshiroRandomSource(worldGenLevel.getSeed() + (long)layer)));
            WorldgenRandom layerRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(worldGenLevel.getSeed() + (long)layer));
            BlendingFunction blendingFunction = functions[layerRandom.nextInt(functions.length)];
            int layerIncrement = layerRandom.nextIntBetweenInclusive(5, 15);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    double biomeAnchor;
                    int blockX = chunkPos.getBlockX(x);
                    int blockZ = chunkPos.getBlockZ(z);
                    int index = x + z * 16;
                    double distSqr = anchors[index];
                    int n = index;
                    maxes[n] = maxes[n] + (int)((layerNoise.noise((double)blockX * 0.05, 0.0, (double)blockZ * 0.05) + 1.0) * 0.5 * Mth.clampedLerp((double)10.0, (double)5.0, (double)layerDelta));
                    int min = mins[index];
                    int max = maxes[index];
                    int minY = min + 1;
                    if (layer == 0) {
                        minY = heightmap[index];
                    }
                    if ((biomeAnchor = biomeAnchors[index]) == 0.0) continue;
                    if (biomeAnchor > 0.0) {
                        double biomeDelta = biomeAnchor / (double)Mth.square((int)biomeSampleDistance);
                        double clampedDelta = Mth.clamp((double)biomeDelta, (double)0.0, (double)1.0);
                        maxes[index] = (int)Mth.clampedLerp((double)minY, (double)max, (double)clampedDelta);
                    }
                    max = maxes[index];
                    int offset = offsets[index];
                    CanyonPiece.buildLayer(blendingFunction, distSqr, distance, blockX, blockZ, minY, min, max, offset, pos1 -> {
                        BlockState state = bands[Math.floorMod((long)pos1.getY() + Math.round((layerNoise.noise((double)((float)pos1.getX() * 0.05f), 0.0, (double)((float)pos1.getZ() * 0.05f)) + 1.0) * 6.0), bands.length - 1)];
                        if (!chunk.getBlockState(pos1).canBeReplaced()) {
                            return true;
                        }
                        chunk.setBlockState(pos1, state, false);
                        return false;
                    });
                    mins[index] = maxes[index];
                    int n2 = index;
                    maxes[n2] = maxes[n2] + layerIncrement;
                    if (offset == 0) {
                        offsets[index] = distance;
                        continue;
                    }
                    double delta1 = (layerNoise.noise((double)((float)blockX * 0.007f), 0.0, (double)((float)blockZ * 0.007f)) + 1.0) * 0.5;
                    double bendFreq = 0.01;
                    double lowBend = Mth.clampedLerp((double)10.0, (double)15.0, (double)(layerNoise.noise((double)(blockX + 1000) * bendFreq, 0.0, (double)(blockZ + 1000) * bendFreq) + 0.5));
                    double highBend = Mth.clampedLerp((double)15.0, (double)65.0, (double)(layerNoise.noise((double)(blockX + 10000) * bendFreq, 0.0, (double)(blockZ + 10000) * bendFreq) + 0.5));
                    int offsetIncrement = (int)Mth.square((double)Mth.clampedLerp((double)5.0, (double)highBend, (double)delta1));
                    int n3 = index;
                    offsets[n3] = offsets[n3] + offsetIncrement;
                }
            }
        }
    }

    private static double nearestBiome(int blockX, int blockZ, int blockSearchRadius, WorldGenLevel level, Predicate<Holder<Biome>> biome) {
        int seaLevel = level.getSeaLevel();
        BlockPos origin = new BlockPos(blockX, seaLevel, blockZ);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int blockSearchDiameter = blockSearchRadius * 2;
        boolean[] sampled = new boolean[blockSearchDiameter * blockSearchDiameter];
        if (!biome.test((Holder<Biome>)level.getBiome((BlockPos)mutable.set(blockX, seaLevel, blockZ)))) {
            return 0.0;
        }
        for (int step = 1; step < blockSearchRadius; step += 2) {
            int slices = 16 * step;
            double sliceSize = (float)Math.PI * 2 / (float)slices;
            for (int i = 0; i <= slices; ++i) {
                int offsetZ;
                double angle = (double)i * sliceSize;
                int offsetX = (int)Math.round(Math.sin(angle) * (double)step);
                int localIndex = (blockSearchRadius + offsetX + ((offsetZ = (int)Math.round(Math.cos(angle) * (double)step)) + blockSearchRadius)) * blockSearchRadius;
                if (sampled[localIndex]) continue;
                sampled[localIndex] = true;
                int worldX = blockX + offsetX;
                int worldZ = blockZ + offsetZ;
                mutable.set(worldX, seaLevel, worldZ);
                Holder biome1 = level.getBiome((BlockPos)mutable);
                if (biome.test((Holder<Biome>)biome1)) continue;
                return mutable.distSqr((Vec3i)origin);
            }
        }
        return -1.0;
    }

    private static double getDistanceToClosestPoint(Position nearest, Position secondNearest, Position worldPos) {
        return CanyonPiece.getDistanceToClosestPoint(nearest.x(), nearest.z(), secondNearest.x(), secondNearest.z(), worldPos.x(), worldPos.z());
    }

    private static double getDistanceToClosestPoint(Position nearest, Position secondNearest, double worldX, double worldZ) {
        return CanyonPiece.getDistanceToClosestPoint(nearest.x(), nearest.z(), secondNearest.x(), secondNearest.z(), worldX, worldZ);
    }

    private static double getDistanceToClosestPoint(long nearest, long secondNearest, int worldX, int worldZ) {
        return CanyonPiece.getDistanceToClosestPoint(ChunkPos.getX((long)nearest), ChunkPos.getZ((long)nearest), ChunkPos.getX((long)secondNearest), ChunkPos.getZ((long)secondNearest), worldX, worldZ);
    }

    private static double getDistanceToClosestPoint(double nearestX, double nearestZ, double secondNearestX, double secondNearestZ, double worldX, double worldZ) {
        return CanyonPiece.getClosestPoint(nearestX, nearestZ, secondNearestX, secondNearestZ, worldX, worldZ).distanceSquared((Vector2dc)new Vector2d(worldX, worldZ));
    }

    private static Vector2d getClosestPoint(double nearestX, double nearestZ, double secondNearestX, double secondNearestZ, double worldX, double worldZ) {
        Vector2d point = new Vector2d(worldX, worldZ);
        Vector2d secondNearest = new Vector2d(secondNearestX, secondNearestZ);
        Vector2d nearest = new Vector2d(nearestX, nearestZ);
        Vector2d line = new Vector2d((Vector2dc)secondNearest).sub((Vector2dc)nearest);
        if (line.lengthSquared() == 0.0) {
            return nearest;
        }
        line.normalize();
        double dotProduct = new Vector2d((Vector2dc)point).sub((Vector2dc)nearest).dot((Vector2dc)line);
        dotProduct = Math.max(0.0, Math.min(dotProduct, line.length()));
        return new Vector2d((Vector2dc)nearest).add((Vector2dc)new Vector2d((Vector2dc)line).mul(dotProduct));
    }

    private static void buildLayer(BlendingFunction function, double distSqr, int distance, int blockX, int blockZ, int minY, int min, int max, int offset, Predicate<BlockPos> blockPosPredicate) {
        double apply = function.apply(Mth.clampedLerp((double)0.0, (double)1.0, (double)((distSqr - (double)offset) / (double)distance)), (double)min, (double)max);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int y = (int)Math.round(apply); y >= minY; --y) {
            mutableBlockPos.set(blockX, y, blockZ);
            if (blockPosPredicate.test((BlockPos)mutableBlockPos)) break;
        }
    }

    private static void setTopBlocks(WorldGenLevel worldGenLevel, ChunkPos chunkPos, int[] topYs, BlockPos.MutableBlockPos mutable) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockX = chunkPos.getBlockX(x);
                int blockZ = chunkPos.getBlockZ(z);
                int idx = x + z * 16;
                int topY = topYs[idx];
                if (topY == Integer.MIN_VALUE) continue;
                mutable.set(blockX, topY, blockZ);
                if (!worldGenLevel.getBlockState((BlockPos)mutable.move(Direction.DOWN)).isAir()) {
                    mutable.move(Direction.UP);
                    worldGenLevel.setBlock((BlockPos)mutable, Blocks.GRASS_BLOCK.defaultBlockState(), 2);
                }
                mutable.move(Direction.DOWN);
                if (worldGenLevel.getBlockState((BlockPos)mutable.move(Direction.DOWN)).isAir()) continue;
                mutable.move(Direction.UP);
                worldGenLevel.setBlock((BlockPos)mutable, Blocks.DIRT.defaultBlockState(), 2);
            }
        }
    }
}

