/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.biome;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.codec.CommentedCodec;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.shadow.blue.endless.jankson.Jankson;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonElement;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonGrammar;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonObject;
import corgitaco.corgilib.shadow.blue.endless.jankson.api.SyntaxError;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import org.jetbrains.annotations.NotNull;

public record BWGWorldGenConfig(Map<ResourceKey<Biome>, Boolean> enabledBiomes, int regionWeight, boolean vanillaAdditions) {
    public static final Path PATH = PlatformHandler.PLATFORM_HANDLER.configPath().resolve("world_generation.json5");
    @NotNull
    public static Supplier<BWGWorldGenConfig> INSTANCE = Suppliers.memoize(BWGWorldGenConfig::getOrCreateConfigFromDisk);
    public static final Codec<BWGWorldGenConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CommentedCodec.of((Codec)Codec.unboundedMap((Codec)ResourceKey.codec((ResourceKey)Registries.BIOME), (Codec)Codec.BOOL), (String)"enabled_biomes", (String)"Which biomes are enabled, if disabled the biome will default to its vanilla counterpart for the given region").orElse(BWGWorldGenConfig.getDefaultBiomes()).forGetter(BWGWorldGenConfig::enabledBiomes), (App)CommentedCodec.of((Codec)Codec.INT, (String)"region_weight", (String)"How much each BWG region weighs. This weight applies to all 3 BWG Regions").orElse((Object)8).forGetter(BWGWorldGenConfig::regionWeight), (App)CommentedCodec.of((Codec)Codec.BOOL, (String)"vanilla_additions", (String)"Whether to add bwg flowers and features to Vanilla Biomes (Config Option for Fabric Only)").orElse((Object)true).forGetter(config -> true)).apply((Applicative)instance, BWGWorldGenConfig::new));

    public static BWGWorldGenConfig createDefault() {
        Object2BooleanMap<ResourceKey<Biome>> enabledBiomes = BWGWorldGenConfig.getDefaultBiomes();
        return new BWGWorldGenConfig((Map<ResourceKey<Biome>, Boolean>)enabledBiomes, 8, true);
    }

    @NotNull
    private static Object2BooleanMap<ResourceKey<Biome>> getDefaultBiomes() {
        Object2BooleanOpenHashMap enabledBiomes = new Object2BooleanOpenHashMap();
        for (ResourceKey<Biome> biomeResourceKey : BWGBiomes.BIOME_FACTORIES.keySet()) {
            enabledBiomes.put(biomeResourceKey, true);
        }
        enabledBiomes.put(BWGBiomes.ERODED_BOREALIS, false);
        return enabledBiomes;
    }

    public static BWGWorldGenConfig getOrCreateConfigFromDisk() {
        BWGWorldGenConfig defaultWorldGenConfig = BWGWorldGenConfig.createDefault();
        if (!PATH.toFile().exists()) {
            BWGWorldGenConfig.createDefaultFile(defaultWorldGenConfig);
            return defaultWorldGenConfig;
        }
        Jankson build = new Jankson.Builder().build();
        try {
            String configFile = Files.readString(PATH).stripTrailing().trim().strip().stripLeading();
            JsonObject load = build.load(configFile);
            Pair configResult = (Pair)CODEC.decode((DynamicOps)JanksonJsonOps.INSTANCE, (Object)load).result().orElseThrow();
            BWGWorldGenConfig config = (BWGWorldGenConfig)configResult.getFirst();
            Reference2ObjectOpenHashMap temporary = new Reference2ObjectOpenHashMap();
            temporary.putAll(defaultWorldGenConfig.enabledBiomes);
            temporary.putAll(config.enabledBiomes);
            BWGWorldGenConfig toCreate = new BWGWorldGenConfig((Map<ResourceKey<Biome>, Boolean>)temporary, config.regionWeight, config.vanillaAdditions);
            BWGWorldGenConfig.createDefaultFile(toCreate);
            return toCreate;
        }
        catch (SyntaxError | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createDefaultFile(BWGWorldGenConfig defaultWorldGenConfig) {
        JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JanksonJsonOps.INSTANCE, (Object)defaultWorldGenConfig).result().orElseThrow();
        String json = jsonElement.toJson(JsonGrammar.JSON5);
        try {
            Files.createDirectories(PATH.getParent(), new FileAttribute[0]);
            Files.writeString(PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

