/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.set;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;

public class BWGBlockSet {
    private static final ArrayList<BWGBlockSet> blockSets = new ArrayList();
    private final Supplier<Block> base;
    private final Supplier<SlabBlock> slab;
    private final Supplier<StairBlock> stairs;
    private final Supplier<WallBlock> wall;

    public BWGBlockSet(String name, BlockBehaviour.Properties properties) {
        this.base = BWGBlocks.registerBasicBlockWithItem(name, properties);
        this.slab = BWGBlocks.registerBlockItem(name + "_slab", () -> new SlabBlock(properties));
        this.stairs = BWGBlocks.registerBlockItem(name + "_stairs", () -> new StairBlock(this.base.get().defaultBlockState(), properties));
        this.wall = BWGBlocks.registerBlockItem(name + "_wall", () -> new WallBlock(properties));
        blockSets.add(this);
    }

    public BWGBlockSet(String name, String alt, BlockBehaviour.Properties properties) {
        this.base = BWGBlocks.registerBasicBlockWithItem(name, properties);
        this.slab = BWGBlocks.registerBlockItem(alt + "_slab", () -> new SlabBlock(properties));
        this.stairs = BWGBlocks.registerBlockItem(alt + "_stairs", () -> new StairBlock(this.base.get().defaultBlockState(), properties));
        this.wall = BWGBlocks.registerBlockItem(alt + "_wall", () -> new WallBlock(properties));
        blockSets.add(this);
    }

    public BWGBlockSet(Supplier<Block> base, Supplier<SlabBlock> slab, Supplier<StairBlock> stairs, Supplier<WallBlock> wall) {
        this.base = base;
        this.slab = slab;
        this.stairs = stairs;
        this.wall = wall;
        blockSets.add(this);
    }

    public BWGBlockSet(String name, MapColor color) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(color);
        this.base = BWGBlocks.registerBasicBlockWithItem(name, properties);
        this.slab = BWGBlocks.registerBlockItem(name + "_slab", () -> new SlabBlock(properties));
        this.stairs = BWGBlocks.registerBlockItem(name + "_stairs", () -> new StairBlock(this.base.get().defaultBlockState(), properties));
        this.wall = BWGBlocks.registerBlockItem(name + "_wall", () -> new WallBlock(properties));
        blockSets.add(this);
    }

    public BWGBlockSet(String name, String alt, MapColor color) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(color);
        this.base = BWGBlocks.registerBasicBlockWithItem(name, properties);
        this.slab = BWGBlocks.registerBlockItem(alt + "_slab", () -> new SlabBlock(properties));
        this.stairs = BWGBlocks.registerBlockItem(alt + "_stairs", () -> new StairBlock(this.base.get().defaultBlockState(), properties));
        this.wall = BWGBlocks.registerBlockItem(alt + "_wall", () -> new WallBlock(properties));
        blockSets.add(this);
    }

    public Block getBase() {
        return this.base.get();
    }

    public SlabBlock getSlab() {
        return this.slab.get();
    }

    public StairBlock getStairs() {
        return this.stairs.get();
    }

    public WallBlock getWall() {
        return this.wall.get();
    }

    public BlockFamily getBlockFamily() {
        return BlockFamilies.familyBuilder((Block)this.getBase()).slab((Block)this.getSlab()).stairs((Block)this.getStairs()).wall((Block)this.getWall()).getFamily();
    }

    public static ArrayList<BWGBlockSet> getBlockSets() {
        return blockSets;
    }
}

