/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.vegetation;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.BloomingAloeVeraBlock;
import org.jetbrains.annotations.NotNull;

public class AloeVeraBlock
extends BushBlock
implements BonemealableBlock {
    private static final MapCodec<AloeVeraBlock> CODEC = AloeVeraBlock.simpleCodec(AloeVeraBlock::new);

    public AloeVeraBlock() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.0f).sound(SoundType.WET_GRASS).noOcclusion().noCollission().randomTicks().pushReaction(PushReaction.DESTROY));
    }

    public AloeVeraBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, RandomSource random) {
        if (random.nextInt(5) == 4) {
            this.growBloomingAloeVera(level, pos);
        }
    }

    public boolean isRandomlyTicking(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.is(BlockTags.SAND);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        this.growBloomingAloeVera(level, pos);
    }

    private void growBloomingAloeVera(ServerLevel level, BlockPos pos) {
        if (level.isEmptyBlock(pos.above())) {
            level.setBlock(pos, (BlockState)BWGBlocks.BLOOMING_ALOE_VERA.get().defaultBlockState().setValue((Property)BloomingAloeVeraBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
            level.setBlock(pos.above(), (BlockState)BWGBlocks.BLOOMING_ALOE_VERA.get().defaultBlockState().setValue((Property)BloomingAloeVeraBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
    }
}

