/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.bush;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.potionstudios.biomeswevegone.world.entity.BWGEntities;
import net.potionstudios.biomeswevegone.world.entity.oddion.Oddion;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.BWGBerryBush;
import org.jetbrains.annotations.NotNull;

public class OddionCrop
extends BWGBerryBush {
    private static final IntegerProperty TIMER = IntegerProperty.create((String)"timer", (int)0, (int)10);
    private static final BooleanProperty HATCHING = BooleanProperty.create((String)"hatching");

    public OddionCrop() {
        super(() -> BWGItems.ODDION_BULB, false);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCHING, (Comparable)Boolean.valueOf(false))).setValue((Property)TIMER, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (stack.is(Items.BONE_MEAL) && (Integer)state.getValue((Property)AGE) == 3 && !((Boolean)state.getValue((Property)HATCHING)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)HATCHING));
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            level.playLocalSound(pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.AMBIENT, 2.0f, 1.0f, false);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean shouldHatch(Level level, BlockState state) {
        return level.random.nextInt(10 - (Integer)state.getValue((Property)TIMER)) == 0;
    }

    public boolean isRandomlyTicking(@NotNull BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)HATCHING)).booleanValue()) {
            if (this.shouldHatch((Level)level, state)) {
                this.spawnOddion((Level)level, pos);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TIMER, (Comparable)Integer.valueOf((Integer)state.getValue((Property)TIMER) + 1)));
                if (level.isClientSide) {
                    level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                    level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
        super.randomTick(state, level, pos, random);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TIMER, HATCHING});
        super.createBlockStateDefinition(builder);
    }

    protected boolean mayPlaceOn(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.getBlock() instanceof FarmBlock;
    }

    private void spawnOddion(Level level, BlockPos pos) {
        Oddion oddion = new Oddion(BWGEntities.ODDION.get(), level);
        oddion.setPos(pos.getX(), pos.getY(), pos.getZ());
        level.addFreshEntity((Entity)oddion);
        level.destroyBlock(pos, true);
    }
}

