/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.bush;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BWGPlacementBushBlock
extends BushBlock {
    @Nullable
    private final VoxelShape SHAPE;
    private final TagKey<Block> validGround;
    private static final MapCodec<BWGPlacementBushBlock> CODEC = BWGPlacementBushBlock.simpleCodec(BWGPlacementBushBlock::new);

    public BWGPlacementBushBlock(BlockBehaviour.Properties properties, @Nullable VoxelShape shape, TagKey<Block> validGround) {
        super(properties);
        this.SHAPE = shape;
        this.validGround = validGround;
    }

    public BWGPlacementBushBlock(BlockBehaviour.Properties properties) {
        this(properties, null, (TagKey<Block>)BlockTags.DIRT);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (this.SHAPE == null) {
            return super.getShape(state, level, pos, context);
        }
        Vec3 Vector3d = state.getOffset(level, pos);
        return this.SHAPE.move(Vector3d.x(), Vector3d.y(), Vector3d.z());
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.is(this.validGround);
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return this.mayPlaceOn(level.getBlockState(pos.below()), (BlockGetter)level, pos);
    }
}

