/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.pumpkinwarden;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpkinWarden
extends PathfinderMob
implements GeoEntity,
VariantHolder<Variant> {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private BlockPos jukebox;
    private boolean party;
    private static final EntityDataAccessor<Boolean> HIDING = SynchedEntityData.defineId(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.defineId(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockState> DATA_CARRY_STATE = SynchedEntityData.defineId(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public Goal moveGoal = new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.7f);
    public Goal runGoal = new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 1.0, 1.0);
    public Goal lookGoal = new LookAtPlayerGoal((Mob)this, Player.class, 2.0f);
    public Goal randLookGoal = new RandomLookAroundGoal((Mob)this);
    private static final RawAnimation HIDE_START = RawAnimation.begin().thenPlay("animation.pumpkinwarden.hidestart");
    private static final RawAnimation HIDE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.hide");
    private static final RawAnimation HIDE_END = RawAnimation.begin().thenPlay("animation.pumpkinwarden.hideend");
    private static final RawAnimation HOLDING_WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_walking");
    private static final RawAnimation HOLDING_IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_idle");
    private static final RawAnimation WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.walking");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.idle");
    private static final RawAnimation WAVE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.wave");

    public PumpkinWarden(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_CARRY_STATE, (Object)Blocks.AIR.defaultBlockState());
        builder.define(HIDING, (Object)false);
        builder.define(TIMER, (Object)0);
        builder.define(DATA_VARIANT, (Object)0);
        super.defineSynchedData(builder);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(Variant.byId(compound.getInt("Variant")));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant().getId());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.4);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN_PIE}), false));
        this.goalSelector.addGoal(3, (Goal)new PumpkinWardenLeaveBlockGoal(this, 1.0, 32, 5));
        this.goalSelector.addGoal(2, (Goal)new PumpkinWardenTakeBlockGoal(this, 1.0, 32, 5));
        this.goalSelector.addGoal(5, (Goal)new StayByBellGoal(this, 1.0, 5000));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        super.registerGoals();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void checkDespawn() {
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.is(BWGBlocks.ROSE.getBlock().asItem())) {
            if (player.level().isClientSide()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getX(), this.getY() + 1.0, this.getZ(), 1.0, 1.0, 1.0);
                this.level().playSound(player, player.blockPosition(), SoundEvents.VILLAGER_AMBIENT, SoundSource.NEUTRAL, 1.0f, this.getVoicePitch());
            }
            itemInHand.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLength(0);
        if (this.isHiding()) {
            if (this.getTimer() < 10) {
                controller.setAnimation(HIDE_START);
                return PlayState.CONTINUE;
            }
            if (this.getTimer() > 10 && this.getTimer() < 180 || !this.level().isDay() && this.getTimer() > 10) {
                controller.setAnimation(HIDE);
                return PlayState.CONTINUE;
            }
            if (this.getTimer() > 180) {
                if (this.level().getBrightness(LightLayer.SKY, this.getOnPos()) > 2) {
                    controller.setAnimation(HIDE_END);
                } else {
                    controller.setAnimation(HIDE);
                }
                return PlayState.CONTINUE;
            }
        }
        if (this.getCarriedBlock() != null) {
            if (event.isMoving()) {
                controller.setAnimation(HOLDING_WALKING);
            } else {
                controller.setAnimation(HOLDING_IDLE);
            }
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.getCarriedBlock() == null) {
            controller.setAnimation(WALKING);
            return PlayState.CONTINUE;
        }
        if (this.party) {
            controller.setAnimation(WAVE);
            return PlayState.CONTINUE;
        }
        controller.setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public void checkGoals() {
        if (this.goalSelector.getAvailableGoals().stream().noneMatch(goal -> goal.getGoal().getClass() == WaterAvoidingRandomStrollGoal.class)) {
            this.goalSelector.addGoal(1, this.moveGoal);
        }
        if (this.goalSelector.getAvailableGoals().stream().noneMatch(goal -> goal.getGoal().getClass() == AvoidEntityGoal.class)) {
            this.goalSelector.addGoal(2, this.runGoal);
        }
        if (this.goalSelector.getAvailableGoals().stream().noneMatch(goal -> goal.getGoal().getClass() == LookAtPlayerGoal.class)) {
            this.goalSelector.addGoal(7, this.lookGoal);
        }
        if (this.goalSelector.getAvailableGoals().stream().noneMatch(goal -> goal.getGoal().getClass() == RandomLookAroundGoal.class)) {
            this.goalSelector.addGoal(3, this.randLookGoal);
        }
    }

    public void setRecordPlayingNearby(@NotNull BlockPos pPos, boolean pIsPartying) {
        this.jukebox = pPos;
        this.party = pIsPartying;
    }

    public void aiStep() {
        super.aiStep();
        if (this.jukebox == null || !this.jukebox.closerToCenterThan((Position)this.position(), 10.0) || !this.level().getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.party = false;
            this.jukebox = null;
        }
        if (!this.level().isClientSide) {
            if (!this.level().isDay()) {
                this.setTimer(this.getTimer() + 1);
                this.setHiding(true);
            } else if (this.getTimer() > 0 && this.getLastHurtByMob() == null) {
                this.setTimer(0);
                this.setHiding(false);
            }
            if (this.getLastHurtByMob() != null) {
                if (this.getTimer() < 200) {
                    this.setTimer(this.getTimer() + 1);
                    this.setHiding(true);
                } else {
                    this.setTimer(0);
                    this.setHiding(false);
                }
            }
        }
        if (this.isHiding()) {
            this.goalSelector.removeGoal(this.moveGoal);
            this.goalSelector.removeGoal(this.runGoal);
            this.goalSelector.removeGoal(this.lookGoal);
            this.goalSelector.removeGoal(this.randLookGoal);
            if (this.getCarriedBlock() != null) {
                BehaviorUtils.throwItem((LivingEntity)this, (ItemStack)this.getCarriedBlock().getBlock().asItem().getDefaultInstance(), (Vec3)new Vec3(this.getX() + 2.0, this.getY(), this.getZ()));
                this.setCarriedBlock(null);
            }
        } else {
            this.checkGoals();
        }
        if (this.getCarriedBlock() != null) {
            this.setItemInHand(this.getUsedItemHand(), this.getCarriedBlock().getBlock().asItem().getDefaultInstance());
        } else {
            this.setItemInHand(this.getUsedItemHand(), ItemStack.EMPTY);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariant(Variant.getSpawnVariant(level.getRandom()));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean canBeLeashed() {
        return true;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.VILLAGER_AMBIENT;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return SoundEvents.VILLAGER_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.VILLAGER_DEATH;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
    }

    public boolean isHiding() {
        return (Boolean)this.entityData.get(HIDING);
    }

    public void setHiding(boolean flag) {
        this.entityData.set(HIDING, (Object)flag);
    }

    public int getTimer() {
        return (Integer)this.entityData.get(TIMER);
    }

    public void setTimer(int flag) {
        this.entityData.set(TIMER, (Object)flag);
    }

    public void setCarriedBlock(BlockState pState) {
        this.entityData.set(DATA_CARRY_STATE, (Object)(pState == null ? Blocks.AIR.defaultBlockState() : pState));
    }

    public BlockState getCarriedBlock() {
        BlockState blockState = (BlockState)this.entityData.get(DATA_CARRY_STATE);
        return blockState == Blocks.AIR.defaultBlockState() ? null : blockState;
    }

    public void setVariant(@NotNull Variant variant) {
        this.entityData.set(DATA_VARIANT, (Object)variant.getId());
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT));
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT(0, "default"),
        PALE(1, "pale");

        private static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        private final String name;
        private final int id;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private static Variant getSpawnVariant(RandomSource random) {
            return (double)random.nextFloat() < 0.05 ? PALE : DEFAULT;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    static class PumpkinWardenLeaveBlockGoal
    extends MoveToBlockGoal {
        public PumpkinWarden warden;
        private int searchNearestBlockDelay = 0;

        public PumpkinWardenLeaveBlockGoal(PumpkinWarden warden, double speed, int range, int y) {
            super((PathfinderMob)warden, speed, range, y);
            this.warden = warden;
        }

        public double acceptedDistance() {
            return 8.0;
        }

        protected int nextStartTick(@NotNull PathfinderMob creature) {
            return 0;
        }

        public boolean canContinueToUse() {
            return this.warden.getCarriedBlock() != null;
        }

        public boolean canUse() {
            if (this.searchNearestBlockDelay > 0) {
                --this.searchNearestBlockDelay;
            }
            if (this.warden.getCarriedBlock() == null) {
                return false;
            }
            return super.canUse();
        }

        protected boolean findNearestBlock() {
            if (this.searchNearestBlockDelay > 0) {
                return false;
            }
            if (this.searchNearestBlockDelay == -1 && this.isValidTarget((LevelReader)this.warden.level(), this.blockPos)) {
                return true;
            }
            if (super.findNearestBlock()) {
                this.searchNearestBlockDelay = -1;
                return true;
            }
            this.searchNearestBlockDelay = 20;
            return false;
        }

        public void tick() {
            super.tick();
            if (this.isReachedTarget() && this.warden.getCarriedBlock() != null) {
                BehaviorUtils.throwItem((LivingEntity)this.warden, (ItemStack)this.warden.getCarriedBlock().getBlock().asItem().getDefaultInstance(), (Vec3)new Vec3((double)this.blockPos.getX(), (double)this.blockPos.getY(), (double)this.blockPos.getZ()));
                this.warden.setCarriedBlock(null);
                this.stop();
            }
        }

        protected boolean isValidTarget(LevelReader level, @NotNull BlockPos pos) {
            return level.getBlockState(pos).is(Blocks.CARVED_PUMPKIN);
        }
    }

    static class PumpkinWardenTakeBlockGoal
    extends MoveToBlockGoal {
        private final PumpkinWarden warden;
        private int searchNearestBlockDelay = 0;

        public PumpkinWardenTakeBlockGoal(PumpkinWarden p, double speed, int range, int y) {
            super((PathfinderMob)p, speed, range, y);
            this.warden = p;
        }

        public boolean canUse() {
            if (this.searchNearestBlockDelay > 0) {
                --this.searchNearestBlockDelay;
            }
            if (this.warden.getCarriedBlock() != null) {
                return false;
            }
            return super.canUse();
        }

        protected boolean findNearestBlock() {
            if (this.searchNearestBlockDelay > 0) {
                return false;
            }
            if (this.searchNearestBlockDelay == -1 && this.isValidTarget((LevelReader)this.warden.level(), this.blockPos)) {
                return true;
            }
            if (super.findNearestBlock()) {
                this.searchNearestBlockDelay = -1;
                return true;
            }
            this.searchNearestBlockDelay = 20;
            return false;
        }

        public double acceptedDistance() {
            return 0.0;
        }

        protected int nextStartTick(@NotNull PathfinderMob creature) {
            return 0;
        }

        public void tick() {
            Level level;
            BlockState blockstate;
            super.tick();
            if (this.isReachedTarget() && (blockstate = (level = this.warden.level()).getBlockState(this.blockPos)).getBlock() instanceof AttachedStemBlock) {
                level.removeBlock(this.blockPos, false);
                level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, this.blockPos, GameEvent.Context.of((Entity)this.warden, (BlockState)blockstate));
                this.warden.setCarriedBlock(blockstate.getBlock().defaultBlockState());
            }
        }

        protected boolean isValidTarget(LevelReader level, @NotNull BlockPos pos) {
            BlockState positionState = level.getBlockState(pos);
            if (positionState.is(Blocks.PUMPKIN) || positionState.is(Blocks.MELON)) {
                return level.getBlockState(pos.relative(Direction.Axis.X, 1)).getBlock() instanceof AttachedStemBlock || level.getBlockState(pos.relative(Direction.Axis.Z, 1)).getBlock() instanceof AttachedStemBlock;
            }
            return false;
        }
    }

    static class StayByBellGoal
    extends MoveToBlockGoal {
        public PumpkinWarden warden;

        public StayByBellGoal(PumpkinWarden pumpkinWarden, double speedModifier, int searchRange) {
            super((PathfinderMob)pumpkinWarden, speedModifier, searchRange);
            this.warden = pumpkinWarden;
        }

        protected boolean isValidTarget(LevelReader level, @NotNull BlockPos pos) {
            List blockStates = level.getBlockStates(new AABB(this.warden.blockPosition()).inflate(30.0)).toList();
            return !((BlockState)blockStates.get(this.warden.random.nextInt(blockStates.size()))).isAir();
        }
    }
}

