/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.levelgen.Heightmap;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGChestBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.manowar.ManOWar;
import net.potionstudios.biomeswevegone.world.entity.oddion.Oddion;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;

public class BWGEntities {
    public static final Supplier<EntityType<ManOWar>> MAN_O_WAR = BWGEntities.createEntity("man_o_war", ManOWar::new, MobCategory.AMBIENT, 0.6f, 1.0f);
    public static final Supplier<EntityType<PumpkinWarden>> PUMPKIN_WARDEN = BWGEntities.createEntity("pumpkin_warden", PumpkinWarden::new, MobCategory.AMBIENT, 1.0f, 1.4f);
    public static final Supplier<EntityType<Oddion>> ODDION = BWGEntities.createEntity("oddion", Oddion::new, MobCategory.AMBIENT, 0.4f, 0.4f);
    public static final Supplier<EntityType<BWGBoatEntity>> BWG_BOAT = BWGEntities.createEntity("boat", BWGBoatEntity::new, MobCategory.MISC, EntityType.BOAT.getWidth(), EntityType.BOAT.getHeight(), 10);
    public static final Supplier<EntityType<BWGChestBoatEntity>> BWG_CHEST_BOAT = BWGEntities.createEntity("chest_boat", BWGChestBoatEntity::new, MobCategory.MISC, EntityType.CHEST_BOAT.getWidth(), EntityType.CHEST_BOAT.getHeight(), 10);

    private static <E extends Entity> Supplier<EntityType<E>> createEntity(String id, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height) {
        return PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.ENTITY_TYPE, id, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category).sized(width, height).build(id));
    }

    private static <E extends Entity> Supplier<EntityType<E>> createEntity(String id, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height, int trackingRange) {
        return PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.ENTITY_TYPE, id, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category).sized(width, height).clientTrackingRange(trackingRange).build(id));
    }

    public static <T extends Mob> void registerSpawnPlacements(Consumer<SpawnPlacement<T>> consumer) {
        consumer.accept(new SpawnPlacement(MAN_O_WAR, SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ManOWar::checkManOWarSpawnRules));
        consumer.accept(new SpawnPlacement(ODDION, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Oddion::checkOddionSpawnRules));
    }

    public static void registerEntityAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> consumer) {
        consumer.accept(MAN_O_WAR.get(), ManOWar.createAttributes().build());
        consumer.accept(PUMPKIN_WARDEN.get(), PumpkinWarden.createAttributes().build());
        consumer.accept(ODDION.get(), Oddion.createAttributes().build());
    }

    public static void entities() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone Entities");
    }

    public record SpawnPlacement<T extends Mob>(Supplier<EntityType<T>> entityType, SpawnPlacementType spawnPlacementType, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
    }
}

