/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.neoforge.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.client.BiomesWeveGoneClient;
import net.potionstudios.biomeswevegone.client.particle.BWGParticles;
import net.potionstudios.biomeswevegone.client.particle.particles.FallingLeafParticle;
import net.potionstudios.biomeswevegone.client.particle.particles.FireFlyParticle;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;

@Mod(value="biomeswevegone", dist={Dist.CLIENT})
public class BiomesWeveGoneClientNeoForge {
    public BiomesWeveGoneClientNeoForge(IEventBus eventBus) {
        BiomesWeveGoneClientNeoForge.init(eventBus);
    }

    public static void init(IEventBus eventBus) {
        eventBus.addListener(BiomesWeveGoneClientNeoForge::neoForgeClientSetup);
        eventBus.addListener(event -> BiomesWeveGoneClient.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1)));
        eventBus.addListener(event -> BiomesWeveGoneClient.registerBlockEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1)));
        eventBus.addListener(BiomesWeveGoneClientNeoForge::registerParticles);
        eventBus.addListener(event -> BiomesWeveGoneClient.registerLayerDefinitions((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1)));
        eventBus.addListener(BiomesWeveGoneClientNeoForge::registerColorChangingBlocks);
        eventBus.addListener(BiomesWeveGoneClientNeoForge::registerItemColorHandlers);
        eventBus.addListener(BiomesWeveGoneClientNeoForge::registerGUILayers);
    }

    private static void neoForgeClientSetup(FMLClientSetupEvent event) {
        BiomesWeveGoneClient.onInitialize(Minecraft.getInstance());
    }

    private static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)BWGParticles.FIREFLY.get(), FireFlyParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.BOREALIS_GLINT.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.WITCH_HAZEL_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.WHITE_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.YELLOW_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.RED_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.SILVER_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.IRONWOOD_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.SPIRIT.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.SPIRIT_LEAVES.get(), FallingLeafParticle.Provider::new);
    }

    private static void registerColorChangingBlocks(RegisterColorHandlersEvent.Block event) {
        event.register((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)view, (BlockPos)pos) : GrassColor.getDefaultColor(), new Block[]{(Block)BWGBlocks.FLOWER_PATCH.get(), (Block)BWGBlocks.TINY_LILY_PADS.get(), (Block)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), (Block)BWGBlocks.OVERGROWN_DACITE.get(), (Block)BWGBlocks.OVERGROWN_STONE.get(), (Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), (Block)BWGBlocks.WHITE_SAKURA_PETALS.get(), (Block)BWGBlocks.YELLOW_SAKURA_PETALS.get()});
        event.register((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)view, (BlockPos)pos) : FoliageColor.get((double)0.5, (double)1.0), new Block[]{(Block)BWGBlocks.CLOVER_PATCH.get(), (Block)BWGBlocks.LEAF_PILE.get(), (Block)BWGBlocks.POISON_IVY.get(), BWGWood.MAHOGANY.leaves(), BWGWood.WILLOW.leaves(), BWGWood.MAPLE.leaves(), (Block)BWGWood.YUCCA_LEAVES.get(), (Block)BWGWood.FLOWERING_YUCCA_LEAVES.get(), (Block)BWGWood.RIPE_YUCCA_LEAVES.get(), BWGWood.CYPRESS.leaves()});
        event.register((state, view, pos, tintIndex) -> BiomesWeveGoneClient.getBorealisIceColor(Objects.requireNonNullElse(pos, BlockPos.ZERO)), new Block[]{(Block)BWGBlocks.BOREALIS_ICE.get(), (Block)BWGBlocks.PACKED_BOREALIS_ICE.get()});
        event.register((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)view, (BlockPos)pos) : -1, new Block[]{BWGBlocks.CARVED_BARREL_CACTUS.get()});
        event.register((state, view, pos, tintIndex) -> {
            int age = (Integer)state.getValue((Property)StemBlock.AGE);
            return FastColor.ARGB32.color((int)(age * 32), (int)(255 - age), (int)(age * 4));
        }, new Block[]{(Block)BWGBlocks.PALE_PUMPKIN_STEM.get()});
        event.register((state, view, pos, tintIndex) -> -2046180, new Block[]{(Block)BWGBlocks.ATTACHED_PALE_PUMPKIN_STEM.get()});
    }

    private static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            Block block = ((BlockItem)stack.getItem()).getBlock();
            return event.getBlockColors().getColor(block.defaultBlockState(), null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)BWGBlocks.TINY_LILY_PADS.get(), (ItemLike)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), (ItemLike)BWGBlocks.CLOVER_PATCH.get(), (ItemLike)BWGBlocks.LEAF_PILE.get(), (ItemLike)BWGBlocks.POISON_IVY.get(), BWGWood.MAHOGANY.leaves(), BWGWood.WILLOW.leaves(), BWGWood.MAPLE.leaves(), (ItemLike)BWGWood.YUCCA_LEAVES.get(), (ItemLike)BWGWood.FLOWERING_YUCCA_LEAVES.get(), (ItemLike)BWGWood.RIPE_YUCCA_LEAVES.get(), BWGWood.CYPRESS.leaves(), (ItemLike)BWGBlocks.LUSH_GRASS_BLOCK.get(), (ItemLike)BWGBlocks.OVERGROWN_DACITE.get(), (ItemLike)BWGBlocks.OVERGROWN_STONE.get()});
    }

    private static void registerGUILayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, BiomesWeveGone.id("textures/misc/palepumpkinblur.png"), (guiGraphics, deltaTracker) -> {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.options.getCameraType().isFirstPerson()) {
                assert (minecraft.player != null);
                if (!minecraft.player.isScoping() && minecraft.player.getInventory().getArmor(3).is(BWGBlocks.CARVED_PALE_PUMPKIN.get().asItem())) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableBlend();
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    guiGraphics.blit(BiomesWeveGone.id("textures/misc/palepumpkinblur.png"), 0, 0, -90, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
                    RenderSystem.disableBlend();
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.enableDepthTest();
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        });
    }
}

