/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.neoforge;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGTradesConfig;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTrades;
import net.potionstudios.biomeswevegone.world.item.brewing.BWGBrewingRecipes;
import net.potionstudios.biomeswevegone.world.item.tools.ToolInteractions;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.BlockFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldVegationPlacedFeatures;
import org.apache.logging.log4j.util.TriConsumer;

public class VanillaCompatNeoForge {
    public static void init() {
        ToolInteractions.registerStrippableBlocks((block, stripped) -> {
            AxeItem.STRIPPABLES = new HashMap(AxeItem.STRIPPABLES);
            AxeItem.STRIPPABLES.put(block, stripped);
        });
        BlockFeatures.registerFlammable((TriConsumer<Block, Integer, Integer>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((FireBlock)((FireBlock)Blocks.FIRE)).setFlammable(arg_0, arg_1, arg_2)));
        ToolInteractions.registerFlattenables(ShovelItem.FLATTENABLES::put);
    }

    public static void registerVanillaCompatEvents(IEventBus bus) {
        bus.addListener(VanillaCompatNeoForge::registerTillables);
        if (BWGTradesConfig.INSTANCE.get().enableTrades()) {
            bus.addListener(VanillaCompatNeoForge::onVillagerTrade);
        }
        bus.addListener(VanillaCompatNeoForge::onBoneMealUse);
        bus.addListener(VanillaCompatNeoForge::registerBrewingRecipes);
        bus.addListener(VanillaCompatNeoForge::onEnderManAnger);
    }

    private static void registerTillables(BlockEvent.BlockToolModificationEvent event) {
        if (event.getItemAbility() == ItemAbilities.HOE_TILL && event.getLevel().getBlockState(event.getPos().above()).isAir()) {
            BlockState state = event.getState();
            if (state.is((Block)BWGBlocks.LUSH_GRASS_BLOCK.get()) || state.is(BWGBlocks.LUSH_DIRT.get())) {
                event.setFinalState(BWGBlocks.LUSH_FARMLAND.get().defaultBlockState());
            } else if (state.is(BWGBlocks.SANDY_DIRT.get())) {
                event.setFinalState(BWGBlocks.SANDY_FARMLAND.get().defaultBlockState());
            } else if (state.is(BWGBlocks.PEAT.get())) {
                event.setFinalState(Blocks.FARMLAND.defaultBlockState());
            }
        }
    }

    private static void onVillagerTrade(VillagerTradesEvent event) {
        if (BWGVillagerTrades.TRADES.containsKey(event.getType())) {
            Int2ObjectMap trades = event.getTrades();
            BWGVillagerTrades.TRADES.get(event.getType()).forEach(pair -> ((List)trades.get(((Integer)pair.getFirst()).intValue())).add((trader, random) -> (MerchantOffer)pair.getSecond()));
        }
    }

    private static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        BWGBrewingRecipes.buildBrewingRecipes((TriConsumer<Holder<Potion>, Item, Holder<Potion>>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((PotionBrewing.Builder)event.getBuilder()).addMix(arg_0, arg_1, arg_2)));
    }

    private static void onEnderManAnger(EnderManAngerEvent event) {
        if (event.getPlayer().getItemBySlot(EquipmentSlot.HEAD).is(BWGBlocks.CARVED_PALE_PUMPKIN.get().asItem())) {
            event.setCanceled(true);
        }
    }

    private static void onBoneMealUse(BonemealEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        if (event.getState().is(Blocks.GRASS_BLOCK) && level.getBiome(event.getPos()).is(BWGBiomes.PRAIRIE)) {
            BlockPos blockPos = event.getPos().above();
            BlockState blockState = BWGBlocks.PRAIRIE_GRASS.get().defaultBlockState();
            Optional optional = level.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(BWGOverworldVegationPlacedFeatures.PRAIRIE_GRASS_BONEMEAL);
            block0: for (int i = 0; i < 128; ++i) {
                Holder holder;
                BlockPos blockPos2 = blockPos;
                RandomSource random = level.getRandom();
                for (int j = 0; j < i / 16; ++j) {
                    if (!level.getBlockState((blockPos2 = blockPos2.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is(Blocks.GRASS_BLOCK) || level.getBlockState(blockPos2).isCollisionShapeFullBlock((BlockGetter)level, blockPos2)) continue block0;
                }
                BlockState blockState2 = level.getBlockState(blockPos2);
                if (blockState2.is(blockState.getBlock()) && random.nextInt(10) == 0) {
                    ((BonemealableBlock)blockState.getBlock()).performBonemeal(level, random, blockPos2, blockState2);
                }
                if (!blockState2.isAir()) continue;
                if (random.nextInt(8) == 0) {
                    List list = ((Biome)level.getBiome(blockPos2).value()).getGenerationSettings().getFlowerFeatures();
                    if (list.isEmpty()) continue;
                    holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.getFirst()).config()).feature();
                } else {
                    if (!optional.isPresent()) continue;
                    holder = (Holder)optional.get();
                }
                ((PlacedFeature)holder.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, blockPos2);
            }
            event.setSuccessful(true);
        }
    }
}

