/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.neoforge;

import com.google.auto.service.AutoService;
import com.mojang.datafixers.DSL;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.neoforge.world.level.block.BWGFarmLandBlock;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import org.jetbrains.annotations.NotNull;

@AutoService(value={PlatformHandler.class})
public class NeoForgePlatformHandler
implements PlatformHandler {
    public static final Map<ResourceKey<?>, DeferredRegister> CACHED = new Reference2ObjectOpenHashMap();

    @Override
    public PlatformHandler.Platform getPlatform() {
        return PlatformHandler.Platform.NEOFORGE;
    }

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get().resolve("biomeswevegone");
    }

    @Override
    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String key, Supplier<BlockEntityType.Builder<T>> builder) {
        return this.register(BuiltInRegistries.BLOCK_ENTITY_TYPE, key, () -> ((BlockEntityType.Builder)builder.get()).build(Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)key)));
    }

    @Override
    public Supplier<SpawnEggItem> createSpawnEgg(Supplier<EntityType<? extends Mob>> entity, int backgroundColor, int highlightColor) {
        return () -> new DeferredSpawnEggItem(entity, backgroundColor, highlightColor, new Item.Properties());
    }

    @Override
    public Supplier<FlowerPotBlock> createPottedBlock(Supplier<? extends Block> block) {
        return () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, block, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT));
    }

    @Override
    public Supplier<net.potionstudios.biomeswevegone.world.level.block.custom.BWGFarmLandBlock> bwgFarmLandBlock(Supplier<Block> dirt) {
        return () -> new BWGFarmLandBlock(dirt);
    }

    @Override
    public WoodType createWoodType(String id, @NotNull BlockSetType setType) {
        return WoodType.register((WoodType)new WoodType("biomeswevegone:" + id, setType));
    }

    @Override
    public Supplier<SimpleParticleType> registerCreateParticle(String name) {
        return this.register(BuiltInRegistries.PARTICLE_TYPE, name, () -> new SimpleParticleType(false));
    }

    @Override
    @SafeVarargs
    public final Supplier<CreativeModeTab> createCreativeTab(String name, Supplier<ItemStack> icon, ArrayList<Supplier<? extends Item>> ... items) {
        return this.register(BuiltInRegistries.CREATIVE_MODE_TAB, name, () -> CreativeModeTab.builder().title((Component)Component.translatable((String)("itemGroup.biomeswevegone." + name))).icon(icon).displayItems((context, entries) -> {
            for (ArrayList item : items) {
                item.forEach(item1 -> entries.accept((ItemLike)item1.get()));
            }
        }).withSearchBar().build());
    }

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, String name, Supplier<T> value) {
        return CACHED.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"biomeswevegone")).register(name, value);
    }

    @Override
    public <T> Supplier<Holder.Reference<T>> registerForHolder(Registry<T> registry, String name, Supplier<T> value) {
        DeferredHolder registryObject = CACHED.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"biomeswevegone")).register(name, value);
        return () -> (Holder.Reference)registryObject.getDelegate();
    }

    public static void registerPottedPlants() {
        BWGBlocks.BLOCKS.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            if (entry.get() instanceof FlowerPotBlock) {
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)((FlowerPotBlock)entry.get()).getPotted())), entry);
            }
        }));
        BWGWood.WOOD.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            if (entry.get() instanceof FlowerPotBlock) {
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)((FlowerPotBlock)entry.get()).getPotted())), entry);
            }
        }));
    }

    public static void register(IEventBus bus) {
        CACHED.values().forEach(deferredRegister -> deferredRegister.register(bus));
    }
}

