/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client;

import java.awt.Color;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.client.renderer.BWGBoatRenderer;
import net.potionstudios.biomeswevegone.world.entity.BWGEntities;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.manowar.ManOWarRenderer;
import net.potionstudios.biomeswevegone.world.entity.oddion.OddionRenderer;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWardenRenderer;
import net.potionstudios.biomeswevegone.world.level.block.entities.BWGBlockEntities;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;

public class BiomesWeveGoneClient {
    private static final ImprovedNoise NOISE = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(1L));

    public static void onInitialize(Minecraft minecraft) {
        BWGWoodSet.woodsets().forEach(set -> BiomesWeveGoneClient.registerWoodTypes(set.woodType()));
    }

    private static void registerWoodTypes(WoodType woodType) {
        Sheets.SIGN_MATERIALS.put(woodType, Sheets.createSignMaterial((WoodType)woodType));
        Sheets.HANGING_SIGN_MATERIALS.put(woodType, Sheets.createHangingSignMaterial((WoodType)woodType));
    }

    public static void registerEntityRenderers(BiConsumer<EntityType<? extends Entity>, EntityRendererProvider> consumer) {
        consumer.accept(BWGEntities.MAN_O_WAR.get(), ManOWarRenderer::new);
        consumer.accept(BWGEntities.PUMPKIN_WARDEN.get(), PumpkinWardenRenderer::new);
        consumer.accept(BWGEntities.ODDION.get(), OddionRenderer::new);
        consumer.accept(BWGEntities.BWG_BOAT.get(), context -> new BWGBoatRenderer(context, false));
        consumer.accept(BWGEntities.BWG_CHEST_BOAT.get(), context -> new BWGBoatRenderer(context, true));
    }

    public static void registerBlockEntityRenderers(BiConsumer<BlockEntityType<? extends BlockEntity>, BlockEntityRendererProvider> consumer) {
        consumer.accept(BWGBlockEntities.SIGNS.get(), SignRenderer::new);
        consumer.accept(BWGBlockEntities.HANGING_SIGNS.get(), HangingSignRenderer::new);
    }

    public static void registerLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> consumer) {
        for (BWGBoatEntity.Type type : BWGBoatEntity.Type.values()) {
            consumer.accept(BWGBoatRenderer.createBoatModelName(type), BoatModel::createBodyModel);
            consumer.accept(BWGBoatRenderer.createChestBoatModelName(type), ChestBoatModel::createBodyModel);
        }
    }

    public static int getBorealisIceColor(BlockPos pos) {
        float frequency = 0.01f;
        float factor = (float)((NOISE.noise((double)((float)pos.getX() * frequency), (double)((float)pos.getY() * frequency), (double)((float)pos.getZ() * frequency)) + 1.0) * 0.5);
        float startHue = 320.0f;
        float endHue = 120.0f;
        float hue = startHue + (endHue - startHue) * factor;
        return Color.getHSBColor(hue / 360.0f, 0.6f, 1.0f).getRGB();
    }
}

