/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.utils;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.pigdad.paganbless.content.blockentities.RuneSlabBlockEntity;
import com.pigdad.paganbless.content.blocks.RuneSlabBlock;
import com.pigdad.paganbless.registries.PBBlocks;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunicCoreUtils {
    @NotNull
    public static Either<Set<BlockPos>, Component> tryGetRunePositions(Level level, BlockPos corePos) {
        List<Pair> possibleFirstPositions = List.of(Pair.of((Object)new Vec3i(0, 0, 2), (Object)new Vec3i(0, 0, -2)), Pair.of((Object)new Vec3i(2, 0, 0), (Object)new Vec3i(-2, 0, 0)));
        List<Vec3i> otherPositions1 = List.of(new Vec3i(2, 0, 1), new Vec3i(2, 0, -1), new Vec3i(-2, 0, 1), new Vec3i(-2, 0, -1));
        List<Vec3i> otherPositions2 = List.of(new Vec3i(1, 0, 2), new Vec3i(-1, 0, 2), new Vec3i(1, 0, -2), new Vec3i(-1, 0, -2));
        BlockPos firstPos1 = corePos.offset((Vec3i)possibleFirstPositions.get(0).getFirst());
        BlockPos firstPos2 = corePos.offset((Vec3i)possibleFirstPositions.get(0).getSecond());
        BlockPos secPos1 = corePos.offset((Vec3i)possibleFirstPositions.get(1).getFirst());
        BlockPos secPos2 = corePos.offset((Vec3i)possibleFirstPositions.get(1).getSecond());
        HashSet<BlockPos> finalPositions = new HashSet<BlockPos>();
        if (level.getBlockState(firstPos1).getBlock() instanceof RuneSlabBlock && level.getBlockState(firstPos2).getBlock() instanceof RuneSlabBlock) {
            offSetPos = RunicCoreUtils.checkPossiblePositions(level, corePos, otherPositions1, firstPos1, firstPos2, finalPositions);
            if (offSetPos != null) {
                return offSetPos;
            }
        } else if (level.getBlockState(secPos1).getBlock() instanceof RuneSlabBlock && level.getBlockState(secPos2).getBlock() instanceof RuneSlabBlock) {
            offSetPos = RunicCoreUtils.checkPossiblePositions(level, corePos, otherPositions2, secPos1, secPos2, finalPositions);
            if (offSetPos != null) {
                return offSetPos;
            }
        } else {
            return RunicCoreUtils.errorFromString("ritual_feedback.paganbless.no_rune_slabs", firstPos1.getX(), firstPos1.getY(), firstPos1.getZ(), secPos1.getX(), secPos1.getY(), secPos1.getZ());
        }
        Block runeType = level.getBlockState((BlockPos)finalPositions.stream().toList().get(0)).getBlock();
        for (BlockPos blockPos : finalPositions) {
            BlockState testBlock = level.getBlockState(blockPos);
            Block block = testBlock.getBlock();
            if (block instanceof RuneSlabBlock) {
                RuneSlabBlock block2 = (RuneSlabBlock)block;
                if (block2.isInert()) {
                    return RunicCoreUtils.errorFromString("ritual_feedback.paganbless.inert_slab", blockPos.getX(), blockPos.getY(), blockPos.getZ());
                }
                if (block2 == runeType) continue;
                return RunicCoreUtils.errorFromString("ritual_feedback.paganbless.wrong_slab", blockPos.getX(), blockPos.getY(), blockPos.getZ());
            }
            return RunicCoreUtils.errorFromString("ritual_feedback.paganbless.invalid_block", blockPos.getX(), blockPos.getY(), blockPos.getZ(), runeType.getName());
        }
        return Either.left(finalPositions);
    }

    @Nullable
    private static Either<Set<BlockPos>, Component> checkPossiblePositions(Level level, BlockPos corePos, List<Vec3i> otherPositions1, BlockPos firstPos1, BlockPos firstPos2, Set<BlockPos> finalPositions) {
        for (Vec3i offSetPos : otherPositions1) {
            if (!(level.getBlockState(corePos.offset(offSetPos)).getBlock() instanceof RuneSlabBlock)) {
                return Either.right((Object)Component.translatable((String)"ritual_feedback.paganbless.no_runeslab_at_pos", (Object[])new Object[]{corePos.offset(offSetPos).getX(), corePos.offset(offSetPos).getY(), corePos.offset(offSetPos).getZ(), level.getBlockState(corePos.offset(offSetPos)).getBlock().getName()}));
            }
            finalPositions.add(corePos.offset(offSetPos));
        }
        finalPositions.add(firstPos1);
        finalPositions.add(firstPos2);
        return null;
    }

    private static Either<@Nullable Set<BlockPos>, Component> errorFromString(String errorTranslationKey, Object ... args) {
        return Either.right((Object)Component.translatable((String)errorTranslationKey, (Object[])args));
    }

    public static void resetPillars(Level level, Set<BlockPos> positions) {
        for (BlockPos blockPos : positions) {
            BlockState blockState = level.getBlockState(blockPos);
            RuneSlabBlock.RuneState runeState = (RuneSlabBlock.RuneState)((Object)blockState.getValue(RuneSlabBlock.RUNE_STATE));
            level.setBlockAndUpdate(blockPos, (BlockState)((BlockState)PBBlocks.RUNE_SLAB_INERT.get().defaultBlockState().setValue(RuneSlabBlock.RUNE_STATE, (Comparable)((Object)runeState))).setValue((Property)RuneSlabBlock.IS_TOP, (Comparable)Boolean.valueOf(false)));
            ((RuneSlabBlockEntity)level.getBlockEntity(blockPos)).setPrevBlock(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString());
            level.setBlockAndUpdate(blockPos.above(), (BlockState)((BlockState)PBBlocks.RUNE_SLAB_INERT.get().defaultBlockState().setValue(RuneSlabBlock.RUNE_STATE, (Comparable)((Object)runeState))).setValue((Property)RuneSlabBlock.IS_TOP, (Comparable)Boolean.valueOf(true)));
        }
    }
}

