/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.registries;

import com.pigdad.paganbless.content.blocks.BaseHangingHerbBlock;
import com.pigdad.paganbless.content.blocks.ChaliceBlock;
import com.pigdad.paganbless.content.blocks.CrankBlock;
import com.pigdad.paganbless.content.blocks.EmptyIncenseBlock;
import com.pigdad.paganbless.content.blocks.EssenceLogBlock;
import com.pigdad.paganbless.content.blocks.FlammableRotatedPillarBlock;
import com.pigdad.paganbless.content.blocks.HangingHerbBlock;
import com.pigdad.paganbless.content.blocks.HerbPlantBlock;
import com.pigdad.paganbless.content.blocks.HerbalistBenchBlock;
import com.pigdad.paganbless.content.blocks.ImbuingCauldronBlock;
import com.pigdad.paganbless.content.blocks.JarBlock;
import com.pigdad.paganbless.content.blocks.LavenderIncenseBlock;
import com.pigdad.paganbless.content.blocks.LogBlock;
import com.pigdad.paganbless.content.blocks.PentacleBlock;
import com.pigdad.paganbless.content.blocks.RopeBlock;
import com.pigdad.paganbless.content.blocks.RueIncenseBlock;
import com.pigdad.paganbless.content.blocks.RuneSlabBlock;
import com.pigdad.paganbless.content.blocks.RunicCoreBlock;
import com.pigdad.paganbless.content.blocks.WaxedHangingHerbBlock;
import com.pigdad.paganbless.content.blocks.WicanWardBlock;
import com.pigdad.paganbless.content.blocks.WinchBlock;
import com.pigdad.paganbless.content.blocks.WinterBerryBushBlock;
import com.pigdad.paganbless.content.items.RuneSlabItem;
import com.pigdad.paganbless.registries.PBItems;
import com.pigdad.paganbless.registries.PBTreeGrowers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public final class PBBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"paganbless");
    public static final BlockSetType BLACK_THORN_SET_TYPE = BlockSetType.register((BlockSetType)new BlockSetType("paganbless:black_thorn"));
    public static final WoodType BLACK_THORN_WOOD_TYPE = WoodType.register((WoodType)new WoodType("paganbless:black_thorn", BLACK_THORN_SET_TYPE));
    public static final List<Supplier<Block>> WOOD_BLOCKS = new ArrayList<Supplier<Block>>();
    public static final Supplier<Block> IMBUING_CAULDRON = PBBlocks.registerBlockAndItem("imbuing_cauldron", () -> new ImbuingCauldronBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(2.0f, 600.0f).noOcclusion()));
    public static final Supplier<Block> HERBALIST_BENCH = PBBlocks.registerBlockAndItem("herbalist_bench", () -> new HerbalistBenchBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(2.0f, 600.0f).noOcclusion()));
    public static final Supplier<Block> CRANK = PBBlocks.registerBlockAndItem("crank", () -> new CrankBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(1.0f, 300.0f).noOcclusion()));
    public static final Supplier<Block> JAR = PBBlocks.registerBlock("jar", () -> new JarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instabreak().noOcclusion()));
    public static final Supplier<Block> WINCH = PBBlocks.registerBlockAndItem("winch", () -> new WinchBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(2.0f, 600.0f).noOcclusion()));
    public static final Supplier<Block> CHALICE = PBBlocks.registerBlock("chalice", () -> new ChaliceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).strength(0.75f, 300.0f)));
    public static final Supplier<Block> RUNIC_CORE = PBBlocks.registerBlockAndItem("runic_core", () -> new RunicCoreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(1.4f, 300.0f).noOcclusion()));
    public static final Supplier<Block> EMPTY_INCENSE = PBBlocks.registerBlockAndItem("empty_incense", () -> new EmptyIncenseBlock(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).strength(0.6f).noOcclusion()));
    public static final Supplier<Block> RUE_INCENSE = PBBlocks.registerBlock("rue_incense", () -> new RueIncenseBlock(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).strength(0.4f).noOcclusion()));
    public static final Supplier<Block> LAVENDER_INCENSE = PBBlocks.registerBlock("lavender_incense", () -> new LavenderIncenseBlock(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).strength(0.4f).noOcclusion()));
    public static final Supplier<Block> DRIED_HANGING_LAVENDER = PBBlocks.registerBlockAndItem("dried_hanging_lavender", () -> new BaseHangingHerbBlock(BlockBehaviour.Properties.of().strength(0.4f).noOcclusion().sound(SoundType.BAMBOO_SAPLING)));
    public static final Supplier<Block> DRIED_HANGING_RUE = PBBlocks.registerBlockAndItem("dried_hanging_rue", () -> new BaseHangingHerbBlock(BlockBehaviour.Properties.of().strength(0.4f).noOcclusion().sound(SoundType.BAMBOO_SAPLING)));
    public static final Supplier<Block> WAXED_HANGING_LAVENDER = PBBlocks.registerBlockAndItem("waxed_hanging_lavender", () -> new WaxedHangingHerbBlock(BlockBehaviour.Properties.of().strength(0.4f).noOcclusion().sound(SoundType.BAMBOO_SAPLING)));
    public static final Supplier<Block> WAXED_HANGING_RUE = PBBlocks.registerBlockAndItem("waxed_hanging_rue", () -> new WaxedHangingHerbBlock(BlockBehaviour.Properties.of().strength(0.4f).noOcclusion().sound(SoundType.BAMBOO_SAPLING)));
    public static final Supplier<Block> HANGING_LAVENDER = PBBlocks.registerBlockAndItem("hanging_lavender", () -> new HangingHerbBlock(BlockBehaviour.Properties.of().strength(0.4f).noOcclusion().sound(SoundType.BAMBOO_SAPLING), DRIED_HANGING_LAVENDER.get(), WAXED_HANGING_LAVENDER.get()));
    public static final Supplier<Block> HANGING_RUE = PBBlocks.registerBlockAndItem("hanging_rue", () -> new HangingHerbBlock(BlockBehaviour.Properties.of().strength(0.4f).noOcclusion().sound(SoundType.BAMBOO_SAPLING), DRIED_HANGING_RUE.get(), WAXED_HANGING_RUE.get()));
    public static final Supplier<Block> ROPE = PBBlocks.registerBlock("rope", () -> new RopeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(0.4f).noOcclusion().sound(SoundType.WOOL)));
    public static final Supplier<Block> PENTACLE = PBBlocks.registerBlock("pentacle", () -> new PentacleBlock(BlockBehaviour.Properties.of().noCollission().noOcclusion().instabreak()));
    public static final Supplier<Block> WICAN_WARD = PBBlocks.registerBlock("wican_ward", () -> new WicanWardBlock(BlockBehaviour.Properties.of().noOcclusion()));
    public static final Supplier<Block> RUNE_SLAB_AMETHYST = PBBlocks.registerRuneSlab("rune_slab_amethyst", 6767774);
    public static final Supplier<Block> RUNE_SLAB_CINNABAR = PBBlocks.registerRuneSlab("rune_slab_cinnabar", 11018551);
    public static final Supplier<Block> RUNE_SLAB_DIAMOND = PBBlocks.registerRuneSlab("rune_slab_diamond", 3649969);
    public static final Supplier<Block> RUNE_SLAB_EMERALD = PBBlocks.registerRuneSlab("rune_slab_emerald", 2205747);
    public static final Supplier<Block> RUNE_SLAB_QUARTZ = PBBlocks.registerRuneSlab("rune_slab_quartz", 13088683);
    public static final Supplier<Block> RUNE_SLAB_LAPIS = PBBlocks.registerRuneSlab("rune_slab_lapis", 2171816);
    public static final Supplier<Block> RUNE_SLAB_INERT = PBBlocks.registerRuneSlab("rune_slab_inert", 0, true);
    public static final Supplier<Block> RUE_PLANT = PBBlocks.registerHerbPlant("rue_plant");
    public static final Supplier<Block> BELLADONNA_PLANT = PBBlocks.registerHerbPlant("belladonna_plant");
    public static final Supplier<Block> HAGS_TAPER_PLANT = PBBlocks.registerHerbPlant("hags_taper_plant");
    public static final Supplier<Block> LAVENDER_PLANT = PBBlocks.registerHerbPlant("lavender_plant");
    public static final Supplier<Block> MANDRAKE_ROOT_PLANT = PBBlocks.registerHerbPlant("mandrake_root_plant");
    public static final Supplier<Block> MUGWORT_PLANT = PBBlocks.registerHerbPlant("mugwort_plant");
    public static final Supplier<Block> WINTER_BERRY_BUSH = PBBlocks.registerBlock("winter_berry_bush", () -> new WinterBerryBushBlock(BlockBehaviour.Properties.of().noCollission().instabreak().sound(SoundType.SWEET_BERRY_BUSH)));
    public static final Supplier<Block> STRIPPED_BLACK_THORN_LOG = PBBlocks.registerWoodBlock("stripped_black_thorn_log", () -> new FlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final Supplier<Block> BLACK_THORN_LOG = PBBlocks.registerWoodBlock("black_thorn_log", () -> new LogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG), STRIPPED_BLACK_THORN_LOG.get()));
    public static final Supplier<Block> ESSENCE_BLACK_THORN_LOG = PBBlocks.registerWoodBlock("essence_black_thorn_log", () -> new EssenceLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).randomTicks()));
    public static final Supplier<Block> STRIPPED_BLACK_THORN_WOOD = PBBlocks.registerWoodBlock("stripped_black_thorn_wood", () -> new FlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final Supplier<Block> BLACK_THORN_WOOD = PBBlocks.registerWoodBlock("black_thorn_wood", () -> new LogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD), STRIPPED_BLACK_THORN_WOOD.get()));
    public static final Supplier<Block> BLACK_THORN_PLANKS = PBBlocks.registerWoodBlock("black_thorn_planks", PBBlocks::plankBlock);
    public static final Supplier<Block> BLACK_THORN_STAIRS = PBBlocks.registerWoodBlock("black_thorn_stairs", () -> new StairBlock(BLACK_THORN_PLANKS.get().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS)));
    public static final Supplier<Block> BLACK_THORN_DOOR = PBBlocks.registerWoodBlock("black_thorn_door", () -> new DoorBlock(BLACK_THORN_SET_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)));
    public static final Supplier<Block> BLACK_THORN_PRESSURE_PLATE = PBBlocks.registerWoodBlock("black_thorn_pressure_plate", () -> new PressurePlateBlock(BLACK_THORN_SET_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)));
    public static final Supplier<Block> BLACK_THORN_FENCE = PBBlocks.registerWoodBlock("black_thorn_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final Supplier<Block> BLACK_THORN_TRAPDOOR = PBBlocks.registerWoodBlock("black_thorn_trapdoor", () -> new TrapDoorBlock(BLACK_THORN_SET_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)));
    public static final Supplier<Block> BLACK_THORN_FENCE_GATE = PBBlocks.registerWoodBlock("black_thorn_fence_gate", () -> new FenceGateBlock(BLACK_THORN_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE)));
    public static final Supplier<Block> BLACK_THORN_BUTTON = PBBlocks.registerWoodBlock("black_thorn_button", () -> new ButtonBlock(BLACK_THORN_SET_TYPE, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)));
    public static final Supplier<Block> BLACK_THORN_SLAB = PBBlocks.registerWoodBlock("black_thorn_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB)));
    public static final Supplier<Block> BLACK_THORN_LEAVES = PBBlocks.registerBlockAndItem("black_thorn_leaves", PBBlocks::leavesBlock);
    public static final Supplier<Block> BLACK_THORN_SAPLING = PBBlocks.registerBlockAndItem("black_thorn_sapling", () -> new SaplingBlock(PBTreeGrowers.BLACK_THORN, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));

    private static <T extends Block> Supplier<T> registerBlockAndItem(String name, Supplier<T> block) {
        DeferredHolder toReturn = BLOCKS.register(name, block);
        PBBlocks.registerItemFromBlock(name, toReturn);
        return toReturn;
    }

    private static Supplier<Block> registerBlock(String name, Supplier<Block> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> void registerItemFromBlock(String name, Supplier<T> block) {
        PBItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static Supplier<Block> registerRuneSlab(String name, int color) {
        return PBBlocks.registerRuneSlab(name, color, false);
    }

    private static Supplier<Block> registerRuneSlab(String name, int color, boolean inert) {
        DeferredHolder toReturn = BLOCKS.register(name, () -> new RuneSlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(2.0f, 600.0f).noOcclusion().requiresCorrectToolForDrops(), color, inert));
        PBItems.ITEMS.register(name, () -> PBBlocks.lambda$registerRuneSlab$36((Supplier)toReturn));
        return toReturn;
    }

    private static Supplier<Block> registerHerbPlant(String name) {
        DeferredHolder toReturn = BLOCKS.register(name, () -> new HerbPlantBlock(BlockBehaviour.Properties.of()));
        PBItems.ITEMS.register(name, () -> PBBlocks.lambda$registerHerbPlant$38((Supplier)toReturn));
        return toReturn;
    }

    private static <T extends Block> Supplier<Block> registerWoodBlock(String name, Supplier<T> block) {
        DeferredHolder toReturn = BLOCKS.register(name, block);
        PBBlocks.registerItemFromBlock(name, toReturn);
        WOOD_BLOCKS.add((Supplier<Block>)toReturn);
        return toReturn;
    }

    @NotNull
    private static LeavesBlock leavesBlock() {
        return new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        };
    }

    @NotNull
    private static Block plankBlock() {
        return new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        };
    }

    private static /* synthetic */ BlockItem lambda$registerHerbPlant$38(Supplier toReturn) {
        return new BlockItem((Block)toReturn.get(), new Item.Properties());
    }

    private static /* synthetic */ RuneSlabItem lambda$registerRuneSlab$36(Supplier toReturn) {
        return new RuneSlabItem((Block)toReturn.get(), new Item.Properties());
    }
}

