/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.events;

import com.pigdad.paganbless.PaganBless;
import com.pigdad.paganbless.data.saved_data.WicanWardSavedData;
import com.pigdad.paganbless.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="paganbless")
public class WicanWardEvents {
    private static boolean isIntentionalSpawn(MobSpawnType spawnType) {
        return switch (spawnType) {
            case MobSpawnType.BREEDING, MobSpawnType.DISPENSER, MobSpawnType.BUCKET, MobSpawnType.CONVERSION, MobSpawnType.SPAWN_EGG, MobSpawnType.TRIGGERED, MobSpawnType.COMMAND, MobSpawnType.EVENT -> true;
            default -> false;
        };
    }

    private static boolean isNaturalSpawn(MobSpawnType spawnType) {
        return switch (spawnType) {
            default -> throw new MatchException(null, null);
            case MobSpawnType.NATURAL, MobSpawnType.CHUNK_GENERATION, MobSpawnType.PATROL, MobSpawnType.TRIAL_SPAWNER -> true;
            case MobSpawnType.BREEDING, MobSpawnType.DISPENSER, MobSpawnType.BUCKET, MobSpawnType.CONVERSION, MobSpawnType.SPAWN_EGG, MobSpawnType.TRIGGERED, MobSpawnType.COMMAND, MobSpawnType.EVENT, MobSpawnType.SPAWNER, MobSpawnType.STRUCTURE, MobSpawnType.MOB_SUMMONED, MobSpawnType.JOCKEY, MobSpawnType.REINFORCEMENT -> false;
        };
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFinalizeSpawn(FinalizeSpawnEvent event) {
        if (WicanWardEvents.isIntentionalSpawn(event.getSpawnType())) {
            return;
        }
        if (!WicanWardEvents.isNaturalSpawn(event.getSpawnType())) {
            return;
        }
        Mob entity = event.getEntity();
        Level level = entity.getCommandSenderWorld();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ());
            WicanWardSavedData data = Utils.getWWData(serverLevel);
            if (data.shouldPreventEntitySpawn(pos)) {
                event.setSpawnCancelled(true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onGlobalTick(ServerTickEvent.Post event) {
        if (PaganBless.server == null) {
            return;
        }
        for (ServerLevel level : PaganBless.server.getAllLevels()) {
            level.getProfiler().push("paganbless_wicanward_" + String.valueOf(level.dimension().registry()));
            WicanWardSavedData data = Utils.getWWData(level);
            data.onGlobalTick((Level)level);
            level.getProfiler().pop();
        }
    }
}

