/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pigdad.paganbless.utils.recipes.PBRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public record RunicRitualRecipe(ItemStack result, ItemStack runeBlock) implements Recipe<PBRecipeInput>
{
    public static final String NAME = "runic_ritual";

    public boolean matches(PBRecipeInput recipeInput, Level level) {
        return true;
    }

    public boolean matchesRunes(Item block, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.runeBlock.is(block);
    }

    public Block getRuneBlock() {
        return Block.byItem((Item)this.runeBlock.getItem());
    }

    @NotNull
    public ItemStack assemble(PBRecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<RunicRitualRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<RunicRitualRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(RunicRitualRecipe::result), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("runeBlock").forGetter(RunicRitualRecipe::runeBlock)).apply((Applicative)builder, RunicRitualRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, RunicRitualRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, RunicRitualRecipe::result, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, RunicRitualRecipe::runeBlock, RunicRitualRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<RunicRitualRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, RunicRitualRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<RunicRitualRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return RunicRitualRecipe.NAME;
        }
    }
}

