/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pigdad.paganbless.utils.recipes.PBRecipeInput;
import com.pigdad.paganbless.utils.recipes.RecipeUtils;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record AnvilSmashingRecipe(NonNullList<SizedIngredient> ingredients, ItemStack result) implements Recipe<PBRecipeInput>
{
    public static final String NAME = "anvil_smashing";

    public AnvilSmashingRecipe(List<SizedIngredient> ingredients, ItemStack result) {
        this(RecipeUtils.listToNonNullList(ingredients), result);
    }

    public boolean matches(@NotNull PBRecipeInput recipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        List<ItemStack> inputItems = recipeInput.items();
        return RecipeUtils.compareItems(inputItems, this.ingredients);
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return RecipeUtils.listToNonNullList(RecipeUtils.iWCToIngredientsSaveCount(this.ingredients));
    }

    @NotNull
    public NonNullList<SizedIngredient> getIngredientsWithCount() {
        return this.ingredients;
    }

    @NotNull
    public ItemStack assemble(PBRecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<AnvilSmashingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<AnvilSmashingRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(AnvilSmashingRecipe::ingredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(AnvilSmashingRecipe::result)).apply((Applicative)builder, AnvilSmashingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, AnvilSmashingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), AnvilSmashingRecipe::ingredients, (StreamCodec)ItemStack.STREAM_CODEC, AnvilSmashingRecipe::result, AnvilSmashingRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<AnvilSmashingRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, AnvilSmashingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<AnvilSmashingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return AnvilSmashingRecipe.NAME;
        }
    }
}

