/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.items;

import com.pigdad.paganbless.data.PBDataComponents;
import com.pigdad.paganbless.data.components.AdvancedBundleContents;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public class HerbPouchItem
extends Item {
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public HerbPouchItem(Item.Properties properties) {
        super(properties);
    }

    public boolean overrideStackedOnOther(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        if (pStack.getCount() == 1 && pAction == ClickAction.SECONDARY) {
            int i;
            AdvancedBundleContents bundlecontents = (AdvancedBundleContents)pStack.get(PBDataComponents.ADVANCED_BUNDLE_CONTENTS);
            if (bundlecontents == null) {
                return false;
            }
            ItemStack itemstack = pSlot.getItem();
            AdvancedBundleContents.Mutable bundlecontents$mutable = new AdvancedBundleContents.Mutable(bundlecontents);
            if (itemstack.isEmpty()) {
                this.playRemoveOneSound((Entity)pPlayer);
                ItemStack itemstack1 = bundlecontents$mutable.removeOne();
                if (itemstack1 != null) {
                    ItemStack itemstack2 = pSlot.safeInsert(itemstack1);
                    bundlecontents$mutable.tryInsert(itemstack2);
                }
            } else if (itemstack.getItem().canFitInsideContainerItems() && bundlecontents$mutable.isValid(itemstack) && (i = bundlecontents$mutable.tryTransfer(pSlot, pPlayer)) > 0) {
                this.playInsertSound((Entity)pPlayer);
            }
            pStack.set(PBDataComponents.ADVANCED_BUNDLE_CONTENTS, (Object)bundlecontents$mutable.toImmutable());
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pStack.getCount() != 1) {
            return false;
        }
        if (pAction == ClickAction.SECONDARY && pSlot.allowModification(pPlayer)) {
            AdvancedBundleContents bundlecontents = (AdvancedBundleContents)pStack.get(PBDataComponents.ADVANCED_BUNDLE_CONTENTS);
            if (bundlecontents == null) {
                return false;
            }
            AdvancedBundleContents.Mutable bundlecontents$mutable = new AdvancedBundleContents.Mutable(bundlecontents);
            if (pOther.isEmpty()) {
                ItemStack itemstack = bundlecontents$mutable.removeOne();
                if (itemstack != null) {
                    this.playRemoveOneSound((Entity)pPlayer);
                    pAccess.set(itemstack);
                }
            } else {
                int i = bundlecontents$mutable.tryInsert(pOther);
                if (i > 0) {
                    this.playInsertSound((Entity)pPlayer);
                }
            }
            pStack.set(PBDataComponents.ADVANCED_BUNDLE_CONTENTS, (Object)bundlecontents$mutable.toImmutable());
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pUsedHand);
        if (HerbPouchItem.dropContents(itemstack, pPlayer)) {
            this.playDropContentsSound((Entity)pPlayer);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public boolean isBarVisible(ItemStack pStack) {
        AdvancedBundleContents bundlecontents = (AdvancedBundleContents)pStack.getOrDefault(PBDataComponents.ADVANCED_BUNDLE_CONTENTS, (Object)AdvancedBundleContents.EMPTY);
        return bundlecontents.weight().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(ItemStack pStack) {
        AdvancedBundleContents bundlecontents = (AdvancedBundleContents)pStack.getOrDefault(PBDataComponents.ADVANCED_BUNDLE_CONTENTS, (Object)AdvancedBundleContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate((Fraction)bundlecontents.weight(), (int)12), 13);
    }

    public int getBarColor(ItemStack pStack) {
        return BAR_COLOR;
    }

    private static boolean dropContents(ItemStack pStack, Player pPlayer) {
        AdvancedBundleContents bundlecontents = (AdvancedBundleContents)pStack.get(PBDataComponents.ADVANCED_BUNDLE_CONTENTS);
        if (bundlecontents != null && !bundlecontents.isEmpty()) {
            pStack.set(PBDataComponents.ADVANCED_BUNDLE_CONTENTS, (Object)AdvancedBundleContents.EMPTY);
            if (pPlayer instanceof ServerPlayer) {
                bundlecontents.itemsCopy().forEach(p_330078_ -> pPlayer.drop(p_330078_, true));
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        return !pStack.has(DataComponents.HIDE_TOOLTIP) && !pStack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((AdvancedBundleContents)pStack.get(PBDataComponents.ADVANCED_BUNDLE_CONTENTS)).map(contents -> new BundleTooltip(contents.asRegularContents())) : Optional.empty();
    }

    public void appendHoverText(ItemStack p_150749_, Item.TooltipContext p_339687_, List<Component> p_150751_, TooltipFlag p_150752_) {
        AdvancedBundleContents bundlecontents = (AdvancedBundleContents)p_150749_.get(PBDataComponents.ADVANCED_BUNDLE_CONTENTS);
        if (bundlecontents != null) {
            int i = Mth.mulAndTruncate((Fraction)bundlecontents.weight(), (int)64);
            p_150751_.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{i, 64}).withStyle(ChatFormatting.GRAY));
        }
    }

    public void onDestroyed(ItemEntity pItemEntity) {
        AdvancedBundleContents bundlecontents = (AdvancedBundleContents)pItemEntity.getItem().get(PBDataComponents.ADVANCED_BUNDLE_CONTENTS);
        if (bundlecontents != null) {
            pItemEntity.getItem().set(PBDataComponents.ADVANCED_BUNDLE_CONTENTS, (Object)AdvancedBundleContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)pItemEntity, bundlecontents.itemsCopy());
        }
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }
}

