/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.mojang.serialization.MapCodec;
import com.pigdad.paganbless.registries.PBItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;

public class WinterBerryBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    private static final VoxelShape SAPLING_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public WinterBerryBushBlock(BlockBehaviour.Properties p_57249_) {
        super(p_57249_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return WinterBerryBushBlock.simpleCodec(WinterBerryBushBlock::new);
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockGetter p_57256_, BlockPos p_57257_, BlockState p_57258_) {
        return new ItemStack((ItemLike)PBItems.WINTER_BERRIES.get());
    }

    @NotNull
    public VoxelShape getShape(BlockState p_57291_, BlockGetter p_57292_, BlockPos p_57293_, CollisionContext p_57294_) {
        if ((Integer)p_57291_.getValue((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return (Integer)p_57291_.getValue((Property)AGE) < 3 ? MID_GROWTH_SHAPE : super.getShape(p_57291_, p_57292_, p_57293_, p_57294_);
    }

    public boolean isRandomlyTicking(BlockState p_57284_) {
        return (Integer)p_57284_.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState p_222563_, ServerLevel p_222564_, BlockPos p_222565_, RandomSource p_222566_) {
        int i = (Integer)p_222563_.getValue((Property)AGE);
        if (i < 3 && p_222564_.getRawBrightness(p_222565_.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)p_222564_, (BlockPos)p_222565_, (BlockState)p_222563_, (p_222566_.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)p_222563_.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            p_222564_.setBlock(p_222565_, blockstate, 2);
            p_222564_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_222565_, GameEvent.Context.of((BlockState)blockstate));
            CommonHooks.fireCropGrowPost((Level)p_222564_, (BlockPos)p_222565_, (BlockState)p_222563_);
        }
    }

    public void entityInside(BlockState p_57270_, Level p_57271_, BlockPos p_57272_, Entity p_57273_) {
        if (p_57273_ instanceof LivingEntity && p_57273_.getType() != EntityType.FOX && p_57273_.getType() != EntityType.BEE) {
            p_57273_.makeStuckInBlock(p_57270_, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(p_57271_.isClientSide || (Integer)p_57270_.getValue((Property)AGE) <= 0 || p_57273_.xOld == p_57273_.getX() && p_57273_.zOld == p_57273_.getZ())) {
                double d0 = Math.abs(p_57273_.getX() - p_57273_.xOld);
                double d1 = Math.abs(p_57273_.getZ() - p_57273_.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    p_57273_.hurt(p_57271_.damageSources().sweetBerryBush(), 1.0f);
                }
            }
        }
    }

    public boolean canSurvive(BlockState p_51028_, LevelReader p_51029_, BlockPos p_51030_) {
        return super.canSurvive(p_51028_, p_51029_, p_51030_) || p_51028_.is(Blocks.SNOW_BLOCK) || p_51028_.is(Blocks.POWDER_SNOW) || p_51028_.is(Blocks.POWDER_SNOW_CAULDRON);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState p_57275_, Level p_57276_, BlockPos p_57277_, Player p_57278_, InteractionHand p_57279_, BlockHitResult p_57280_) {
        boolean flag;
        int i = (Integer)p_57275_.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && itemStack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (i > 1) {
            int j = 1 + p_57276_.random.nextInt(2);
            WinterBerryBushBlock.popResource((Level)p_57276_, (BlockPos)p_57277_, (ItemStack)new ItemStack((ItemLike)PBItems.WINTER_BERRIES.get(), j + (flag ? 1 : 0)));
            p_57276_.playSound(null, p_57277_, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + p_57276_.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)p_57275_.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            p_57276_.setBlock(p_57277_, blockstate, 2);
            p_57276_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_57277_, GameEvent.Context.of((Entity)p_57278_, (BlockState)blockstate));
            return ItemInteractionResult.sidedSuccess((boolean)p_57276_.isClientSide);
        }
        return super.useItemOn(itemStack, p_57275_, p_57276_, p_57277_, p_57278_, p_57279_, p_57280_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57282_) {
        p_57282_.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader p_256056_, BlockPos p_57261_, BlockState p_57262_) {
        return (Integer)p_57262_.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level p_222558_, RandomSource p_222559_, BlockPos p_222560_, BlockState p_222561_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_222553_, RandomSource p_222554_, BlockPos p_222555_, BlockState p_222556_) {
        int i = Math.min(3, (Integer)p_222556_.getValue((Property)AGE) + 1);
        p_222553_.setBlock(p_222555_, (BlockState)p_222556_.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

