/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.mojang.serialization.MapCodec;
import com.pigdad.paganbless.api.blocks.RotatableEntityBlock;
import com.pigdad.paganbless.content.blockentities.WinchBlockEntity;
import com.pigdad.paganbless.registries.PBBlockEntities;
import com.pigdad.paganbless.utils.WinchUtils;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WinchBlock
extends RotatableEntityBlock {
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)3.0, (double)0.0, (double)0.5, (double)13.0, (double)15.0, (double)15.5), Block.box((double)2.0, (double)15.0, (double)3.5, (double)14.0, (double)16.0, (double)12.5), Block.box((double)13.0, (double)4.0, (double)3.5, (double)14.0, (double)15.0, (double)12.5), Block.box((double)14.0, (double)5.5, (double)5.5, (double)16.0, (double)10.5, (double)10.5), Block.box((double)0.0, (double)5.5, (double)5.5, (double)2.0, (double)10.5, (double)10.5), Block.box((double)2.0, (double)4.0, (double)3.5, (double)3.0, (double)15.0, (double)12.5)).reduce(Shapes::or).get();
    public static final VoxelShape ROTATED_SHAPE = Stream.of(Block.box((double)0.5, (double)0.0, (double)3.0, (double)15.5, (double)15.0, (double)13.0), Block.box((double)3.5, (double)15.0, (double)2.0, (double)12.5, (double)16.0, (double)14.0), Block.box((double)3.5, (double)4.0, (double)13.0, (double)12.5, (double)15.0, (double)14.0), Block.box((double)5.5, (double)5.5, (double)13.0, (double)10.5, (double)10.5, (double)15.0), Block.box((double)5.5, (double)5.5, (double)1.0, (double)10.5, (double)10.5, (double)3.0), Block.box((double)3.5, (double)4.0, (double)2.0, (double)12.5, (double)15.0, (double)3.0)).reduce(Shapes::or).get();

    public WinchBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return WinchBlock.simpleCodec(WinchBlock::new);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return state != null ? (BlockState)state.setValue((Property)RotatableEntityBlock.FACING, (Comparable)context.getPlayer().getDirection().getOpposite().getClockWise()) : null;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH, Direction.SOUTH -> SHAPE;
            case Direction.EAST, Direction.WEST -> ROTATED_SHAPE;
            default -> null;
        };
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!pPlayer.isShiftKeyDown() && blockEntity instanceof WinchBlockEntity) {
            WinchBlockEntity winchBlockEntity = (WinchBlockEntity)blockEntity;
            pPlayer.openMenu((MenuProvider)winchBlockEntity, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    protected void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pState != pOldState) {
            WinchBlockEntity blockEntity = (WinchBlockEntity)pLevel.getBlockEntity(pPos);
            int newDistance = WinchUtils.recheckConnections(pLevel, pPos, null);
            blockEntity.setDistance(newDistance);
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            WinchBlockEntity blockEntity = (WinchBlockEntity)level.getBlockEntity(pos);
            blockEntity.drop();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState pState, BlockEntityType<T> blockEntityType) {
        return WinchBlock.createTickerHelper(blockEntityType, PBBlockEntities.WINCH.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new WinchBlockEntity(blockPos, blockState);
    }
}

