/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.pigdad.paganbless.content.blockentities.RunicCoreBlockEntity;
import com.pigdad.paganbless.data.saved_data.RunicCoreSavedData;
import com.pigdad.paganbless.registries.PBBlockEntities;
import com.pigdad.paganbless.registries.PBTags;
import com.pigdad.paganbless.utils.BlockStateProperties;
import com.pigdad.paganbless.utils.RunicCoreUtils;
import com.pigdad.paganbless.utils.Utils;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunicCoreBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = BlockStateProperties.ACTIVE;
    public static final DirectionProperty FACING = net.minecraft.world.level.block.state.properties.BlockStateProperties.HORIZONTAL_FACING;

    public RunicCoreBlock(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return RunicCoreBlock.simpleCodec(RunicCoreBlock::new);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getPlayer().getDirection());
    }

    @NotNull
    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.add(new Property[]{ACTIVE, FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new RunicCoreBlockEntity(p_153215_, p_153216_);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult p_316140_) {
        if (itemStack.is(PBTags.ItemTags.FIRE_LIGHTER) && !((Boolean)blockState.getValue((Property)ACTIVE)).booleanValue()) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            level.playSound(player, blockPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return ItemInteractionResult.SUCCESS;
        }
        if (itemStack.is(ItemTags.SHOVELS) && ((Boolean)blockState.getValue((Property)ACTIVE)).booleanValue()) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            level.playSound(player, blockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof RunicCoreBlockEntity) {
            RunicCoreBlockEntity runicCoreBlockEntity = (RunicCoreBlockEntity)blockEntity;
            ItemStackHandler stackHandler = runicCoreBlockEntity.getItemHandler();
            if (stackHandler.getStackInSlot(0).isEmpty()) {
                Either<Set<BlockPos>, Component> runePosResult = RunicCoreUtils.tryGetRunePositions(level, blockPos);
                if (!level.isClientSide()) {
                    if (runePosResult.right().isEmpty() && ((Boolean)blockState.getValue((Property)ACTIVE)).booleanValue()) {
                        player.sendSystemMessage((Component)Component.translatable((String)"ritual_feedback.paganbless.valid"));
                    } else {
                        if (!((Boolean)blockState.getValue((Property)ACTIVE)).booleanValue()) {
                            player.sendSystemMessage((Component)Component.translatable((String)"ritual_feedback.paganbless.unlit"));
                        }
                        player.sendSystemMessage((Component)Component.translatable((String)"ritual_feedback.paganbless.incomplete"));
                        player.sendSystemMessage((Component)runePosResult.right().get());
                    }
                }
            } else {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackHandler.getStackInSlot(0));
                stackHandler.setStackInSlot(0, ItemStack.EMPTY);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return RunicCoreBlock.createTickerHelper(pBlockEntityType, PBBlockEntities.RUNIC_CORE.get(), (level, pos, state, entity) -> {
            if (level.isClientSide()) {
                entity.clientTick();
            }
            entity.commonTick();
        });
    }

    protected void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            RunicCoreSavedData savedData = Utils.getRCData(serverLevel);
            savedData.addBlockPos(pPos);
        }
    }

    protected void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            RunicCoreSavedData savedData = Utils.getRCData(serverLevel);
            savedData.removeBlockPos(pPos);
        }
    }
}

